/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.SimpleEventManager;

public abstract class GraphListenerBase
extends SimpleEventManager {
    protected abstract void addTripleEvent(Graph var1, Triple var2);

    protected abstract void deleteTripleEvent(Graph var1, Triple var2);

    public Stream<GraphListener> listeners() {
        return this.listeners.stream();
    }

    public void notifyAddTriple(Graph g, Triple ts) {
        this.addTripleEvent(g, ts);
        super.notifyAddTriple(g, ts);
    }

    public void notifyAddArray(Graph g, Triple[] ts) {
        for (Triple t : ts) {
            this.addTripleEvent(g, t);
        }
        super.notifyAddArray(g, ts);
    }

    public void notifyAddList(Graph g, List<Triple> ts) {
        ts.forEach(t -> this.addTripleEvent(g, (Triple)t));
        super.notifyAddList(g, ts);
    }

    public void notifyAddIterator(Graph g, List<Triple> ts) {
        ts.forEach(t -> this.addTripleEvent(g, (Triple)t));
        super.notifyAddIterator(g, ts);
    }

    public void notifyAddIterator(Graph g, Iterator<Triple> ts) {
        ts.forEachRemaining(t -> this.addTripleEvent(g, (Triple)t));
        super.notifyAddIterator(g, ts);
    }

    public void notifyDeleteTriple(Graph g, Triple t) {
        this.deleteTripleEvent(g, t);
        super.notifyDeleteTriple(g, t);
    }

    public void notifyDeleteArray(Graph g, Triple[] ts) {
        for (Triple t : ts) {
            this.deleteTripleEvent(g, t);
        }
        super.notifyDeleteArray(g, ts);
    }

    public void notifyDeleteList(Graph g, List<Triple> ts) {
        ts.forEach(t -> this.deleteTripleEvent(g, (Triple)t));
        super.notifyDeleteList(g, ts);
    }

    public void notifyDeleteIterator(Graph g, List<Triple> ts) {
        ts.forEach(t -> this.deleteTripleEvent(g, (Triple)t));
        super.notifyDeleteIterator(g, ts);
    }

    public void notifyDeleteIterator(Graph g, Iterator<Triple> ts) {
        ts.forEachRemaining(t -> this.deleteTripleEvent(g, (Triple)t));
        super.notifyDeleteIterator(g, ts);
    }
}

