/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.impl;

import java.util.function.Predicate;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.WrappedCapabilities;
import org.apache.jena.graph.impl.WrappedGraph;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.util.iterator.ExtendedIterator;

public class GraphPlain
extends WrappedGraph {
    private final Capabilities capabilities;

    public static Graph plain(Graph base) {
        if (!base.getCapabilities().handlesLiteralTyping()) {
            return base;
        }
        return new GraphPlain(base);
    }

    public static Graph plain() {
        return GraphPlain.plain(GraphMemFactory.createDefaultGraph());
    }

    protected GraphPlain(Graph other) {
        super(other);
        this.capabilities = new WrappedCapabilities(this.base.getCapabilities()){

            @Override
            public boolean handlesLiteralTyping() {
                return false;
            }
        };
    }

    @Override
    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public void remove(Node s, Node p, Node o) {
        GraphUtil.remove(this, s, p, o);
    }

    @Override
    public boolean contains(Triple t) {
        return this.contains(t.getSubject(), t.getPredicate(), t.getObject());
    }

    @Override
    public boolean contains(Node s, Node p, Node o) {
        if (!this.base.contains(s, p, o)) {
            return false;
        }
        ExtendedIterator<Triple> iter = this.find(s, p, o);
        boolean b = iter.hasNext();
        iter.close();
        return b;
    }

    @Override
    public ExtendedIterator<Triple> find(Triple m) {
        return this.find(m.getSubject(), m.getPredicate(), m.getObject());
    }

    @Override
    public ExtendedIterator<Triple> find(Node subj, Node pred, Node obj) {
        ExtendedIterator<Triple> iter = this.base.find(subj, pred, obj);
        Predicate<Triple> predicate = dataTriple -> GraphPlain.sameTermMatch(subj, pred, obj, dataTriple);
        iter = iter.filterKeep(predicate);
        return iter;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.base.toString();
    }

    private static boolean sameTermMatch(Node matchSubj, Node matchPred, Node matchObj, Triple dataTriple) {
        return GraphPlain.sameTermMatch(matchSubj, dataTriple.getSubject()) && GraphPlain.sameTermMatch(matchPred, dataTriple.getPredicate()) && GraphPlain.sameTermMatch(matchObj, dataTriple.getObject());
    }

    private static boolean sameTermMatch(Node match, Node data) {
        if (!Util.isLangString(data) || !Util.isLangString(match)) {
            return match == null || match == Node.ANY || match.equals(data);
        }
        String lex1 = data.getLiteralLexicalForm();
        String lex2 = data.getLiteralLexicalForm();
        String lang1 = data.getLiteralLanguage();
        String lang2 = data.getLiteralLanguage();
        return lex1.equals(lex2) && lang1.equalsIgnoreCase(lang2);
    }
}

