/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.graph;

import java.util.Collection;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.util.graph.Findable;
import org.apache.jena.sparql.util.graph.FindableCollection;
import org.apache.jena.sparql.util.graph.FindableGraph;

public class GNode {
    public final Findable findable;
    public final Node node;

    public static GNode create(Graph graph, Node node) {
        return new GNode(graph, node);
    }

    public static GNode subject(Graph graph, Triple triple) {
        return triple == null ? null : GNode.create(graph, triple.getSubject());
    }

    public static GNode predicate(Graph graph, Triple triple) {
        return triple == null ? null : GNode.create(graph, triple.getPredicate());
    }

    public static GNode object(Graph graph, Triple triple) {
        return triple == null ? null : GNode.create(graph, triple.getObject());
    }

    public GNode(Graph graph, Node node) {
        this.findable = new FindableGraph(graph);
        this.node = node;
    }

    public GNode(BasicPattern triples, Node node) {
        this.findable = new FindableCollection(triples.getList());
        this.node = node;
    }

    public GNode(Collection<Triple> triples, Node node) {
        this.findable = new FindableCollection(triples);
        this.node = node;
    }

    public GNode(GNode other, Node node) {
        this.findable = other.findable;
        this.node = node;
    }

    public String toString() {
        return "gnode:" + String.valueOf(this.node);
    }
}

