/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lang;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIx;
import org.apache.jena.irix.RelativeIRIException;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.riot.lang.extra.LangParserLib;
import org.apache.jena.riot.system.Checker;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_BNode;
import org.apache.jena.sparql.expr.E_Exists;
import org.apache.jena.sparql.expr.E_IRI;
import org.apache.jena.sparql.expr.E_IRI2;
import org.apache.jena.sparql.expr.E_NotExists;
import org.apache.jena.sparql.expr.E_URI;
import org.apache.jena.sparql.expr.E_URI2;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.lang.LabelToNodeMap;
import org.apache.jena.sparql.modify.request.QuadAccSink;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.TripleCollector;
import org.apache.jena.sparql.syntax.TripleCollectorMark;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParserBase {
    protected final Node XSD_TRUE = NodeConst.nodeTrue;
    protected final Node XSD_FALSE = NodeConst.nodeFalse;
    protected final Node nRDFtype = NodeConst.nodeRDFType;
    protected final Node nRDFnil = NodeConst.nodeNil;
    protected final Node nRDFfirst = NodeConst.nodeFirst;
    protected final Node nRDFrest = NodeConst.nodeRest;
    protected final Node nRDFsubject = RDF.Nodes.subject;
    protected final Node nRDFpredicate = RDF.Nodes.predicate;
    protected final Node nRDFobject = RDF.Nodes.object;
    protected final Node nRDFreifies = RDF.Nodes.reifies;
    private boolean bNodesAreVariables = true;
    private boolean bNodesAreAllowed = true;
    final LabelToNodeMap bNodeLabels = LabelToNodeMap.createBNodeMap();
    final LabelToNodeMap anonVarLabels;
    protected LabelToNodeMap activeLabelMap = this.anonVarLabels = LabelToNodeMap.createVarMap();
    protected Set<String> previousLabels = new HashSet<String>();
    private boolean allowAggregatesInExpressions = false;
    private int aggregateDepth = 0;
    protected Prologue prologue;
    public static final String ParserLoggerName = "SPARQL";
    public static Logger parserLog = LoggerFactory.getLogger((String)"SPARQL");
    private static final ErrorHandler errorHandler = ErrorHandlerFactory.errorHandlerStd(parserLog);
    private boolean skolomizedBNodes = ARQ.isTrue(ARQ.constantBNodeLabels);
    private Node annotationReifierId = null;

    public void setPrologue(Prologue prologue) {
        this.prologue = prologue;
    }

    public Prologue getPrologue() {
        return this.prologue;
    }

    protected void setBase(String iriStr, int line, int column) {
        if (this.isBNodeIRI(iriStr)) {
            QueryParserBase.throwParseException("Blank node URI syntax used for BASE", line, column);
        }
        iriStr = this.resolveIRI(iriStr, line, column);
        this.getPrologue().setBaseURI(iriStr);
    }

    protected void setPrefix(String prefix, String uriStr, int line, int column) {
        this.getPrologue().setPrefix(prefix, uriStr);
    }

    protected void setInConstructTemplate(boolean b) {
        this.setBNodesAreVariables(!b);
    }

    protected boolean getBNodesAreVariables() {
        return this.bNodesAreVariables;
    }

    protected void setBNodesAreVariables(boolean bNodesAreVariables) {
        this.bNodesAreVariables = bNodesAreVariables;
        this.activeLabelMap = bNodesAreVariables ? this.anonVarLabels : this.bNodeLabels;
    }

    protected boolean getBNodesAreAllowed() {
        return this.bNodesAreAllowed;
    }

    protected void setBNodesAreAllowed(boolean bNodesAreAllowed) {
        this.bNodesAreAllowed = bNodesAreAllowed;
    }

    protected boolean getAllowAggregatesInExpressions() {
        return this.allowAggregatesInExpressions;
    }

    protected void setAllowAggregatesInExpressions(boolean allowAggregatesInExpressions) {
        this.allowAggregatesInExpressions = allowAggregatesInExpressions;
    }

    protected void startAggregate() {
        ++this.aggregateDepth;
    }

    protected int getAggregateDepth() {
        return this.aggregateDepth;
    }

    protected void finishAggregate() {
        --this.aggregateDepth;
    }

    protected Element compressGroupOfOneGroup(ElementGroup elg) {
        Element e1;
        if (elg.size() == 1 && (e1 = elg.get(0)) instanceof ElementGroup) {
            return e1;
        }
        return elg;
    }

    protected Node createLiteralInteger(String lexicalForm) {
        return NodeFactory.createLiteralDT((String)lexicalForm, (RDFDatatype)XSDDatatype.XSDinteger);
    }

    protected Node createLiteralDouble(String lexicalForm) {
        return NodeFactory.createLiteralDT((String)lexicalForm, (RDFDatatype)XSDDatatype.XSDdouble);
    }

    protected Node createLiteralDecimal(String lexicalForm) {
        return NodeFactory.createLiteralDT((String)lexicalForm, (RDFDatatype)XSDDatatype.XSDdecimal);
    }

    protected Node stripSign(Node node) {
        if (!node.isLiteral()) {
            return node;
        }
        String lex = node.getLiteralLexicalForm();
        String lang = node.getLiteralLanguage();
        RDFDatatype dt = node.getLiteralDatatype();
        if (!lex.startsWith("-") && !lex.startsWith("+")) {
            throw new ARQInternalErrorException("Literal does not start with a sign: " + lex);
        }
        lex = lex.substring(1);
        return NodeFactory.createLiteral((String)lex, (String)lang, (RDFDatatype)dt);
    }

    protected void checkString(String string, int line, int column) {
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (Character.isLowSurrogate(ch)) {
                throw new QueryParseException("Bad surrogate pair (low surrogate without high surrogate)", line, column);
            }
            if (!Character.isHighSurrogate(ch)) continue;
            if (++i == string.length()) {
                throw new QueryParseException("Bad surrogate pair (end of string)", line, column);
            }
            char ch1 = string.charAt(i);
            if (Character.isLowSurrogate(ch1)) continue;
            throw new QueryParseException("Bad surrogate pair (high surrogate not followed by low surrogate)", line, column);
        }
    }

    protected Node createLiteralString(String lexicalForm, int line, int column) {
        return NodeFactory.createLiteralString((String)lexicalForm);
    }

    protected Node createLiteralDT(String lexicalForm, String datatypeURI, int line, int column) {
        return this.createLiteralAny(lexicalForm, null, null, datatypeURI, line, column);
    }

    protected Node createLiteralLang(String lexicalForm, String langTagDir, int line, int column) {
        return this.createLiteralAny(lexicalForm, langTagDir, null, null, line, column);
    }

    private Node createLiteralAny(String lexicalForm, String langTag, String textDirStr, String datatypeURI, int line, int column) {
        int idx;
        Node n = null;
        if (datatypeURI != null) {
            if (langTag != null || textDirStr != null) {
                throw new ARQInternalErrorException("Datatype with lang/langDir");
            }
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatypeURI);
            n = NodeFactory.createLiteralDT((String)lexicalForm, (RDFDatatype)dType);
            return n;
        }
        if (langTag == null && textDirStr == null) {
            return NodeFactory.createLiteralString((String)lexicalForm);
        }
        langTag = langTag.substring(1);
        String textDirStr2 = textDirStr;
        String langTag2 = langTag;
        if (textDirStr == null && (idx = langTag.indexOf("--")) >= 0) {
            textDirStr2 = langTag.substring(idx + 2);
            langTag2 = langTag.substring(0, idx);
        }
        if (langTag2 != null && textDirStr2 != null) {
            if (!TextDirection.isValid((String)textDirStr2)) {
                throw new QueryParseException("Illegal base direction: '" + textDirStr2 + "'", line, column);
            }
            return NodeFactory.createLiteralDirLang((String)lexicalForm, (String)langTag2, (String)textDirStr2);
        }
        return NodeFactory.createLiteralLang((String)lexicalForm, (String)langTag2);
    }

    protected long integerValue(String s) {
        try {
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
            if (s.startsWith("0x")) {
                s = s.substring(2);
                return Long.parseLong(s, 16);
            }
            return Long.parseLong(s);
        }
        catch (NumberFormatException ex) {
            try {
                BigInteger integer = new BigInteger(s);
                QueryParserBase.throwParseException("Number '" + s + "' is a valid number but can't not be stored in a long");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            throw new QueryParseException(ex, -1, -1);
        }
    }

    protected double doubleValue(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        double valDouble = Double.parseDouble(s);
        return valDouble;
    }

    protected static String stripQuotes(String s) {
        return s.substring(1, s.length() - 1);
    }

    protected static String stripQuotes3(String s) {
        return s.substring(3, s.length() - 3);
    }

    protected static String stripChars(String s, int n) {
        return LangParserLib.stripChars(s, n);
    }

    protected Var createVariable(String s, int line, int column) {
        s = s.substring(1);
        return Var.alloc(s);
    }

    protected Node createTripleTerm(Node s, Node p, Node o, int line, int column) {
        return NodeFactory.createTripleTerm((Node)s, (Node)p, (Node)o);
    }

    protected String resolveQuotedIRI(String iriStr, int line, int column) {
        iriStr = QueryParserBase.stripQuotes(iriStr);
        iriStr = QueryParserBase.unescapeUnicode(iriStr, line, column);
        this.checkString(iriStr, line, column);
        return this.resolveIRI(iriStr, line, column);
    }

    protected String resolveIRI(String iriStr, int line, int column) {
        if (this.isBNodeIRI(iriStr)) {
            return iriStr;
        }
        if (this.getPrologue() == null) {
            return iriStr;
        }
        if (this.getPrologue().getBase() == null) {
            return iriStr;
        }
        IRIx irix = this.resolveIRIx(iriStr, line, column);
        return irix.toString();
    }

    private IRIx resolveIRIx(String iriStr, long line, long col) {
        if (iriStr.contains(" ")) {
            errorHandler.warning("Bad IRI: <" + iriStr + "> Spaces are not legal in URIs/IRIs.", line, col);
            return IRIx.createAny((String)iriStr);
        }
        try {
            IRIx resolvedIRIx = this.getPrologue().getBase().resolve(iriStr);
            return resolvedIRIx;
        }
        catch (RelativeIRIException ex) {
            errorHandler.error("Relative IRI: " + iriStr, line, col);
            return IRIx.createAny((String)iriStr);
        }
        catch (IRIException ex) {
            String msg = ex.getMessage();
            Checker.iriViolationMessage(iriStr, true, msg, line, col, errorHandler);
            return IRIx.createAny((String)iriStr);
        }
    }

    protected String resolvePName(String prefixedName, int line, int column) {
        int idx = ((String)prefixedName).indexOf(58);
        String prefix = ((String)prefixedName).substring(0, idx);
        String local = ((String)prefixedName).substring(idx + 1);
        local = QueryParserBase.unescapePName(local, line, column);
        prefixedName = prefix + ":" + local;
        String s = this.getPrologue().expandPrefixedName((String)prefixedName);
        if (s == null) {
            if (ARQ.isTrue(ARQ.fixupUndefinedPrefixes)) {
                return RiotLib.fixupPrefixes.apply((String)prefixedName);
            }
            QueryParserBase.throwParseException("Unresolved prefixed name: " + (String)prefixedName, line, column);
        }
        return s;
    }

    protected Node createNode(String iri) {
        if (this.skolomizedBNodes) {
            return RiotLib.createIRIorBNode(iri);
        }
        return NodeFactory.createURI((String)iri);
    }

    protected boolean isBNodeIRI(String iri) {
        return this.skolomizedBNodes && RiotLib.isBNodeIRI(iri);
    }

    protected void startBasicGraphPattern() {
        this.activeLabelMap.clear();
    }

    protected void endBasicGraphPattern() {
        this.previousLabels.addAll(this.activeLabelMap.getLabels());
    }

    protected void startTriplesBlock() {
    }

    protected void endTriplesBlock() {
    }

    protected void startGroup(ElementGroup elg) {
        this.endBasicGraphPattern();
        this.startBasicGraphPattern();
    }

    protected void endGroup(ElementGroup elg) {
        this.endBasicGraphPattern();
    }

    protected void checkConcrete(Node n, int line, int column) {
        if (!n.isConcrete()) {
            QueryParserBase.throwParseException("Term is not concrete: " + String.valueOf(n), line, column);
        }
    }

    protected Node createListNode(int line, int column) {
        return this.createBNode(line, column);
    }

    protected Node createBNode(int line, int column) {
        if (!this.bNodesAreAllowed) {
            QueryParserBase.throwParseException("Blank nodes not allowed in DELETE templates", line, column);
        }
        return this.activeLabelMap.allocNode();
    }

    protected Node createBNode(String label, int line, int column) {
        if (!this.bNodesAreAllowed) {
            QueryParserBase.throwParseException("Blank nodes not allowed in DELETE templates: " + label, line, column);
        }
        if (this.previousLabels.contains(label)) {
            QueryParserBase.throwParseException("Blank node label reuse not allowed at this point: " + label, line, column);
        }
        return this.activeLabelMap.asNode(label);
    }

    protected Node preConditionReifier(Node s, Node p, Path path, Node o, int line, int column) {
        if (p != null) {
            return p;
        }
        if (path instanceof P_Link) {
            return ((P_Link)path).getNode();
        }
        QueryParserBase.throwParseException("Only simple paths allowed with reifier syntax", line, column);
        return null;
    }

    protected Expr createExprExists(Element element) {
        return new E_Exists(element);
    }

    protected Expr createExprNotExists(Element element) {
        return new E_NotExists(element);
    }

    protected String fixupPrefix(String prefix, int line, int column) {
        if (prefix.endsWith(":")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    protected void setAccGraph(QuadAccSink acc, Node gn) {
        acc.setGraph(gn);
    }

    protected void insert(TripleCollector acc, Node s, Node p, Node o) {
        acc.addTriple(Triple.create((Node)s, (Node)p, (Node)o));
    }

    protected void insert(TripleCollectorMark acc, int index, Node s, Node p, Node o) {
        acc.addTriple(index, Triple.create((Node)s, (Node)p, (Node)o));
    }

    protected void insert(TripleCollector acc, Node s, Node p, Path path, Node o) {
        if (p == null) {
            acc.addTriplePath(new TriplePath(s, path, o));
        } else {
            acc.addTriple(Triple.create((Node)s, (Node)p, (Node)o));
        }
    }

    protected void insert(TripleCollectorMark acc, int index, Node s, Node p, Path path, Node o) {
        if (p == null) {
            acc.addTriplePath(index, new TriplePath(s, path, o));
        } else {
            acc.addTriple(index, Triple.create((Node)s, (Node)p, (Node)o));
        }
    }

    protected void insert(TripleCollector target, ElementPathBlock source) {
        for (TriplePath path : source.getPattern()) {
            if (path.isTriple()) {
                target.addTriple(path.asTriple());
                continue;
            }
            target.addTriplePath(path);
        }
    }

    protected Node insertTripleReifier(TripleCollector acc, Node reifierId, Node s, Node p, Node o, int line, int column) {
        Node tripleTerm = this.createTripleTerm(s, p, o, line, column);
        if (reifierId == null) {
            reifierId = this.createBNode(line, column);
        }
        Triple t = Triple.create((Node)reifierId, (Node)this.nRDFreifies, (Node)tripleTerm);
        acc.addTriple(t);
        return reifierId;
    }

    protected void setReifierId(Node reifId) {
        this.annotationReifierId = reifId;
    }

    protected Node getOrAllocReifierId(TripleCollector acc, Node s, Node p, Node o, int line, int column) {
        if (this.annotationReifierId != null) {
            return this.annotationReifierId;
        }
        Node reifierId = this.createBNode(-1, -1);
        this.insertTripleReifier(acc, reifierId, s, p, o, line, column);
        return reifierId;
    }

    protected void clearReifierId() {
        this.annotationReifierId = null;
    }

    protected Expr asExpr(Node n) {
        return ExprLib.nodeToExpr(n);
    }

    protected Expr makeFunction_IRI(Expr expr) {
        return new E_IRI(this.prologue.getBaseURI(), expr);
    }

    protected Expr makeFunction_URI(Expr expr) {
        return new E_URI(this.prologue.getBaseURI(), expr);
    }

    protected Expr makeFunction_IRI(Expr expr1, Expr expr2) {
        if (expr2 == null) {
            return this.makeFunction_IRI(expr1);
        }
        return new E_IRI2(expr1, this.prologue.getBaseURI(), expr2);
    }

    protected Expr makeFunction_URI(Expr expr1, Expr expr2) {
        if (expr2 == null) {
            return this.makeFunction_URI(expr1);
        }
        return new E_URI2(expr1, this.prologue.getBaseURI(), expr2);
    }

    protected Expr makeFunction_BNode() {
        return E_BNode.create();
    }

    protected Expr makeFunction_BNode(Expr expr) {
        return E_BNode.create(expr);
    }

    static String unescapeStr(String s) {
        return QueryParserBase.unescapeStr(s, -1, -1);
    }

    protected static String unescapeStr(String s, int line, int column) {
        return QueryParserBase.unescape(s, '\\', false, line, column);
    }

    protected static String unescapeUnicode(String s, int line, int column) {
        return QueryParserBase.unescape(s, '\\', true, line, column);
    }

    protected static String unescape(String s, char escape, boolean pointCodeOnly, int line, int column) {
        try {
            return EscapeStr.unescape((String)s, (char)escape, (boolean)pointCodeOnly);
        }
        catch (AtlasException ex) {
            QueryParserBase.throwParseException(ex.getMessage(), line, column);
            return null;
        }
    }

    protected static String unescapePName(String s, int line, int column) {
        char escape = '\\';
        int idx = s.indexOf(escape);
        if (idx == -1) {
            return s;
        }
        int len = s.length();
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    ++line;
                    column = 1;
                    break;
                }
                default: {
                    ++column;
                }
            }
            if (ch != escape) {
                sb.append(ch);
                continue;
            }
            if (i >= s.length() - 1) {
                QueryParserBase.throwParseException("Illegal escape at end of string", line, column);
            }
            char ch2 = s.charAt(i + 1);
            ++column;
            ++i;
            switch (ch2) {
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case '_': 
                case '~': {
                    sb.append(ch2);
                    continue block6;
                }
                default: {
                    QueryParserBase.throwParseException("Illegal prefix name escape: " + ch2, line, column);
                }
            }
        }
        return sb.toString();
    }

    protected void warnDeprecation(String msg) {
        Log.warn((Object)this, (String)msg);
    }

    public static void throwParseException(String msg, int line, int column) {
        throw new QueryParseException("Line " + line + ", column " + column + ": " + msg, line, column);
    }

    public static void throwParseException(String msg) {
        throw new QueryParseException(msg, -1, -1);
    }
}

