/*
 * Decompiled with CFR 0.152.
 */
package tdb.cmdline;

import arq.cmdline.ModDataset;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerVocab;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.tdb1.TDB1Factory;
import org.apache.jena.tdb1.assembler.VocabTDB1;
import org.apache.jena.tdb1.base.file.Location;
import org.apache.jena.tdb1.transaction.DatasetGraphTransaction;
import tdb.cmdline.ModTDBAssembler;

public class ModTDBDataset
extends ModDataset {
    private ArgDecl argMem = new ArgDecl(true, "mem", "data");
    private ModTDBAssembler modAssembler = new ModTDBAssembler();
    private String inMemFile = null;

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.add(this.argMem, "--mem=FILE", "Execute on an in-memory TDB database (for testing)");
        cmdLine.addModule(this.modAssembler);
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        this.inMemFile = cmdLine.getValue(this.argMem);
        this.modAssembler.processArgs(cmdLine);
    }

    @Override
    public Dataset createDataset() {
        if (this.inMemFile != null) {
            Dataset ds = TDB1Factory.createDataset();
            RDFDataMgr.read((Dataset)ds, (String)this.inMemFile);
            return ds;
        }
        if (this.modAssembler.getAssemblerFile() != null) {
            Dataset thing = null;
            try {
                thing = ModTDBDataset.buildDataset(this.modAssembler);
                if (thing != null && !(thing.asDatasetGraph() instanceof DatasetGraphTransaction)) {
                    Log.warn((Object)this, (String)"Unexpected: Not a TDB dataset for type DatasetTDB");
                }
                if (thing == null) {
                    thing = (Dataset)AssemblerUtils.build((String)this.modAssembler.getAssemblerFile(), (Resource)DatasetAssemblerVocab.tDataset);
                }
            }
            catch (JenaException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CmdException("Error creating", ex);
            }
            return thing;
        }
        if (this.modAssembler.getLocation() == null) {
            throw new CmdException("No assembler file nor location provided");
        }
        Dataset ds = TDB1Factory.createDataset((Location)this.modAssembler.getLocation());
        return ds;
    }

    private static Dataset buildDataset(ModTDBAssembler modAssembler) {
        Model spec = AssemblerUtils.readAssemblerFile((String)modAssembler.getAssemblerFile());
        Resource root = GraphUtils.findRootByType((Model)spec, (Resource)VocabTDB1.tDatasetTDB);
        if (root == null) {
            root = GraphUtils.findRootByType((Model)spec, (Resource)VocabTDB1.tDatasetTDB1);
        }
        if (root == null) {
            throw new ARQException("Not found: No such type: <" + String.valueOf(VocabTDB1.tDatasetTDB) + ">");
        }
        return (Dataset)Assembler.general().open(root);
    }

    public Location getLocation() {
        List<String> x = this.locations();
        if (x.size() == 0) {
            return null;
        }
        return Location.create((String)x.get(0));
    }

    public List<String> locations() {
        ArrayList<String> locations = new ArrayList<String>();
        if (this.modAssembler.getLocation() != null) {
            locations.add(this.modAssembler.getLocation().getDirectoryPath());
        }
        if (this.modAssembler.getAssemblerFile() != null) {
            Model m = RDFDataMgr.loadModel((String)this.modAssembler.getAssemblerFile());
            Query query2 = QueryFactory.create((String)"PREFIX tdb:     <http://jena.hpl.hp.com/2008/tdb#> SELECT ?dir { [] tdb:location ?dir FILTER (isURI(?dir)) }");
            try (QueryExecution qExec = QueryExecutionFactory.create((Query)query2, (Model)m);){
                ResultSet rs = qExec.execSelect();
                while (rs.hasNext()) {
                    String x = rs.nextSolution().getResource("dir").getURI();
                    locations.add(x);
                }
            }
        }
        return locations;
    }
}

