/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import java.util.List;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.FunctionBase;

public class AFN_AdjustToTimezone
extends FunctionBase {
    @Override
    public void checkBuild(String uri, ExprList args) {
        if (args.size() != 1 && args.size() != 2) {
            throw new QueryBuildException("Function '" + Lib.className((Object)this) + "' takes one or two arguments");
        }
    }

    @Override
    public NodeValue exec(List<NodeValue> args) {
        if (args.size() != 1 && args.size() != 2) {
            throw new ExprEvalException("afn:adjust-to-timezone: : Wrong number of arguments: " + args.size() + " : [wanted 1 or 2]");
        }
        NodeValue v1 = args.get(0);
        if (!(v1.isDateTime() || v1.isDate() || v1.isTime())) {
            throw new ExprEvalException("afn:adjust-to-timezone: Arg 1 not a dateTime, date or time : " + v1);
        }
        if (args.size() == 2) {
            NodeValue v2 = args.get(1);
            return XSDFuncOp.adjustToTimezone(v1, v2);
        }
        return XSDFuncOp.adjustToTimezone(v1, null);
    }
}

