/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.sparql.core.Var;

public class VariableUsageTracker {
    private Deque<Map<String, Integer>> stack = new ArrayDeque<Map<String, Integer>>();
    private Map<String, Integer> variables = new HashMap<String, Integer>();

    public void push() {
        this.stack.push(this.variables);
        this.variables = new HashMap<String, Integer>();
    }

    public void pop() {
        if (this.stack.size() == 0) {
            throw new IllegalStateException("Stack is empty");
        }
        this.variables = this.stack.pop();
    }

    public void increment(Collection<Var> vars) {
        for (Var var : vars) {
            this.increment(var);
        }
    }

    public void increment(String var) {
        if (!this.variables.containsKey(var)) {
            this.variables.put(var, 1);
        } else {
            this.variables.put(var, this.variables.get(var) + 1);
        }
    }

    public void increment(Var var) {
        this.increment(var.getName());
    }

    public void decrement(Collection<Var> vars) {
        for (Var var : vars) {
            this.decrement(var);
        }
    }

    public void decrement(String var) {
        if (this.variables.containsKey(var)) {
            this.variables.put(var, this.variables.get(var) - 1);
            if (this.variables.get(var) <= 0) {
                this.variables.remove(var);
            }
        }
    }

    public void decrement(Var var) {
        this.decrement(var.getName());
    }

    public int getUsageCount(String var) {
        Integer i = this.variables.get(var);
        return i != null ? i : 0;
    }

    public int getUsageCount(Var var) {
        return this.getUsageCount(var.getName());
    }
}

