/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetWriter;
import org.apache.jena.riot.resultset.ResultSetWriterFactory;
import org.apache.jena.riot.rowset.RowSetWriter;
import org.apache.jena.riot.rowset.RowSetWriterFactory;
import org.apache.jena.riot.rowset.RowSetWriterRegistry;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.util.Context;

public class ResultSetWriterRegistry {
    private static Map<Lang, ResultSetWriterFactory> registry = new ConcurrentHashMap<Lang, ResultSetWriterFactory>();
    private static boolean initialized = false;

    public static ResultSetWriterFactory getFactory(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.get(lang);
    }

    public static boolean isRegistered(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.containsKey(lang);
    }

    public static void register(Lang lang, ResultSetWriterFactory factory) {
        Objects.requireNonNull(lang);
        Objects.requireNonNull(factory);
        registry.put(lang, factory);
    }

    public static Set<Lang> registered() {
        return Set.copyOf(registry.keySet());
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        RowSetWriterRegistry.init();
        ResultSetWriterFactory factory = lang -> new ResultSetWriterAdapter(lang);
        ResultSetWriterRegistry.register(ResultSetLang.RS_XML, factory);
        ResultSetWriterRegistry.register(ResultSetLang.RS_JSON, factory);
        ResultSetWriterRegistry.register(ResultSetLang.RS_CSV, factory);
        ResultSetWriterRegistry.register(ResultSetLang.RS_TSV, factory);
        ResultSetWriterRegistry.register(ResultSetLang.RS_Text, factory);
        ResultSetWriterRegistry.register(ResultSetLang.RS_Thrift, factory);
        ResultSetWriterRegistry.register(ResultSetLang.RS_Protobuf, factory);
        ResultSetWriterRegistry.register(ResultSetLang.RS_None, factory);
    }

    private static class ResultSetWriterAdapter
    implements ResultSetWriter {
        private final Lang lang;
        private final RowSetWriterFactory writerFactory;

        ResultSetWriterAdapter(Lang lang) {
            this.lang = lang;
            this.writerFactory = RowSetWriterRegistry.getFactory(lang);
        }

        private RowSetWriter writer() {
            return this.writerFactory.create(this.lang);
        }

        @Override
        public void write(OutputStream out, ResultSet resultSet, Context context2) {
            this.writer().write(out, RowSet.adapt(resultSet), context2);
        }

        @Override
        public void write(Writer out, ResultSet resultSet, Context context2) {
            this.writer().write(out, RowSet.adapt(resultSet), context2);
        }

        @Override
        public void write(OutputStream out, boolean result, Context context2) {
            this.writer().write(out, result, context2);
        }
    }
}

