/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.store.roaring;

import java.util.stream.Stream;
import org.apache.jena.atlas.lib.Copyable;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem2.collection.FastHashMap;
import org.apache.jena.mem2.collection.FastHashSet;
import org.apache.jena.mem2.pattern.MatchPattern;
import org.apache.jena.mem2.pattern.PatternClassifier;
import org.apache.jena.mem2.store.TripleStore;
import org.apache.jena.mem2.store.roaring.RoaringBitmapTripleIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.util.iterator.SingletonIterator;
import org.roaringbitmap.FastAggregation;
import org.roaringbitmap.ImmutableBitmapDataProvider;
import org.roaringbitmap.RoaringBitmap;

public class RoaringTripleStore
implements TripleStore {
    private static final String UNKNOWN_PATTERN_CLASSIFIER = "Unknown pattern classifier: %s";
    private static final RoaringBitmap EMPTY_BITMAP = new RoaringBitmap();
    final NodesToBitmapsMap subjectBitmaps;
    final NodesToBitmapsMap predicateBitmaps;
    final NodesToBitmapsMap objectBitmaps;
    final TripleSet triples;

    public RoaringTripleStore() {
        this.subjectBitmaps = new NodesToBitmapsMap();
        this.predicateBitmaps = new NodesToBitmapsMap();
        this.objectBitmaps = new NodesToBitmapsMap();
        this.triples = new TripleSet();
    }

    private RoaringTripleStore(RoaringTripleStore storeToCopy) {
        this.subjectBitmaps = storeToCopy.subjectBitmaps.copy();
        this.predicateBitmaps = storeToCopy.predicateBitmaps.copy();
        this.objectBitmaps = storeToCopy.objectBitmaps.copy();
        this.triples = storeToCopy.triples.copy();
    }

    private static void addIndex(NodesToBitmapsMap map, Node node, int index) {
        RoaringBitmap bitmap = map.computeIfAbsent(node, RoaringBitmap::new);
        bitmap.add(index);
    }

    private static void removeIndex(NodesToBitmapsMap map, Node node, int index) {
        RoaringBitmap bitmap = (RoaringBitmap)map.get(node);
        bitmap.remove(index);
        if (bitmap.isEmpty()) {
            map.removeUnchecked(node);
        }
    }

    @Override
    public void add(Triple triple) {
        int index = this.triples.addAndGetIndex(triple);
        if (index < 0) {
            return;
        }
        RoaringTripleStore.addIndex(this.subjectBitmaps, triple.getSubject(), index);
        RoaringTripleStore.addIndex(this.predicateBitmaps, triple.getPredicate(), index);
        RoaringTripleStore.addIndex(this.objectBitmaps, triple.getObject(), index);
    }

    @Override
    public void remove(Triple triple) {
        int index = this.triples.removeAndGetIndex(triple);
        if (index < 0) {
            return;
        }
        RoaringTripleStore.removeIndex(this.subjectBitmaps, triple.getSubject(), index);
        RoaringTripleStore.removeIndex(this.predicateBitmaps, triple.getPredicate(), index);
        RoaringTripleStore.removeIndex(this.objectBitmaps, triple.getObject(), index);
    }

    @Override
    public void clear() {
        this.subjectBitmaps.clear();
        this.predicateBitmaps.clear();
        this.objectBitmaps.clear();
        this.triples.clear();
    }

    @Override
    public int countTriples() {
        return this.triples.size();
    }

    @Override
    public boolean isEmpty() {
        return this.triples.isEmpty();
    }

    @Override
    public boolean contains(Triple tripleMatch) {
        MatchPattern matchPattern = PatternClassifier.classify(tripleMatch);
        switch (matchPattern) {
            case SUB_ANY_ANY: 
            case ANY_PRE_ANY: 
            case ANY_ANY_OBJ: 
            case SUB_PRE_ANY: 
            case ANY_PRE_OBJ: 
            case SUB_ANY_OBJ: {
                return this.hasMatchInBitmaps(tripleMatch, matchPattern);
            }
            case SUB_PRE_OBJ: {
                return this.triples.containsKey(tripleMatch);
            }
            case ANY_ANY_ANY: {
                return !this.isEmpty();
            }
        }
        throw new IllegalStateException(String.format(UNKNOWN_PATTERN_CLASSIFIER, new Object[]{PatternClassifier.classify(tripleMatch)}));
    }

    private ImmutableBitmapDataProvider getBitmapForMatch(Triple tripleMatch, MatchPattern matchPattern) {
        switch (matchPattern) {
            case SUB_ANY_ANY: {
                return (ImmutableBitmapDataProvider)this.subjectBitmaps.getOrDefault(tripleMatch.getSubject(), EMPTY_BITMAP);
            }
            case ANY_PRE_ANY: {
                return (ImmutableBitmapDataProvider)this.predicateBitmaps.getOrDefault(tripleMatch.getPredicate(), EMPTY_BITMAP);
            }
            case ANY_ANY_OBJ: {
                return (ImmutableBitmapDataProvider)this.objectBitmaps.getOrDefault(tripleMatch.getObject(), EMPTY_BITMAP);
            }
            case SUB_PRE_ANY: {
                RoaringBitmap subjectBitmap = (RoaringBitmap)this.subjectBitmaps.get(tripleMatch.getSubject());
                if (null == subjectBitmap) {
                    return EMPTY_BITMAP;
                }
                RoaringBitmap predicateBitmap = (RoaringBitmap)this.predicateBitmaps.get(tripleMatch.getPredicate());
                if (null == predicateBitmap) {
                    return EMPTY_BITMAP;
                }
                return FastAggregation.naive_and((RoaringBitmap[])new RoaringBitmap[]{subjectBitmap, predicateBitmap});
            }
            case ANY_PRE_OBJ: {
                RoaringBitmap predicateBitmap = (RoaringBitmap)this.predicateBitmaps.get(tripleMatch.getPredicate());
                if (null == predicateBitmap) {
                    return EMPTY_BITMAP;
                }
                RoaringBitmap objectBitmap = (RoaringBitmap)this.objectBitmaps.get(tripleMatch.getObject());
                if (null == objectBitmap) {
                    return EMPTY_BITMAP;
                }
                return FastAggregation.naive_and((RoaringBitmap[])new RoaringBitmap[]{predicateBitmap, objectBitmap});
            }
            case SUB_ANY_OBJ: {
                RoaringBitmap subjectBitmap = (RoaringBitmap)this.subjectBitmaps.get(tripleMatch.getSubject());
                if (null == subjectBitmap) {
                    return EMPTY_BITMAP;
                }
                RoaringBitmap objectBitmap = (RoaringBitmap)this.objectBitmaps.get(tripleMatch.getObject());
                if (null == objectBitmap) {
                    return EMPTY_BITMAP;
                }
                return FastAggregation.naive_and((RoaringBitmap[])new RoaringBitmap[]{subjectBitmap, objectBitmap});
            }
            case SUB_PRE_OBJ: {
                throw new IllegalArgumentException("Getting bitmap for match pattern SPO ist not supported because it is not efficient");
            }
            case ANY_ANY_ANY: {
                throw new IllegalArgumentException("Cannot get bitmap for match pattern ___");
            }
        }
        throw new IllegalStateException(String.format(UNKNOWN_PATTERN_CLASSIFIER, new Object[]{PatternClassifier.classify(tripleMatch)}));
    }

    private boolean hasMatchInBitmaps(Triple tripleMatch, MatchPattern matchPattern) {
        switch (matchPattern) {
            case SUB_ANY_ANY: {
                return this.subjectBitmaps.containsKey(tripleMatch.getSubject());
            }
            case ANY_PRE_ANY: {
                return this.predicateBitmaps.containsKey(tripleMatch.getPredicate());
            }
            case ANY_ANY_OBJ: {
                return this.objectBitmaps.containsKey(tripleMatch.getObject());
            }
            case SUB_PRE_ANY: {
                RoaringBitmap subjectBitmap = (RoaringBitmap)this.subjectBitmaps.get(tripleMatch.getSubject());
                if (null == subjectBitmap) {
                    return false;
                }
                RoaringBitmap predicateBitmap = (RoaringBitmap)this.predicateBitmaps.get(tripleMatch.getPredicate());
                if (null == predicateBitmap) {
                    return false;
                }
                return RoaringBitmap.intersects((RoaringBitmap)subjectBitmap, (RoaringBitmap)predicateBitmap);
            }
            case ANY_PRE_OBJ: {
                RoaringBitmap predicateBitmap = (RoaringBitmap)this.predicateBitmaps.get(tripleMatch.getPredicate());
                if (null == predicateBitmap) {
                    return false;
                }
                RoaringBitmap objectBitmap = (RoaringBitmap)this.objectBitmaps.get(tripleMatch.getObject());
                if (null == objectBitmap) {
                    return false;
                }
                return RoaringBitmap.intersects((RoaringBitmap)objectBitmap, (RoaringBitmap)predicateBitmap);
            }
            case SUB_ANY_OBJ: {
                RoaringBitmap subjectBitmap = (RoaringBitmap)this.subjectBitmaps.get(tripleMatch.getSubject());
                if (null == subjectBitmap) {
                    return false;
                }
                RoaringBitmap objectBitmap = (RoaringBitmap)this.objectBitmaps.get(tripleMatch.getObject());
                if (null == objectBitmap) {
                    return false;
                }
                return RoaringBitmap.intersects((RoaringBitmap)subjectBitmap, (RoaringBitmap)objectBitmap);
            }
            case SUB_PRE_OBJ: {
                throw new IllegalArgumentException("Getting bitmap for match pattern SPO ist not supported because it is not efficient");
            }
            case ANY_ANY_ANY: {
                throw new IllegalArgumentException("Cannot get bitmap for match pattern ___");
            }
        }
        throw new IllegalStateException(String.format(UNKNOWN_PATTERN_CLASSIFIER, new Object[]{PatternClassifier.classify(tripleMatch)}));
    }

    @Override
    public Stream<Triple> stream() {
        return this.triples.keyStream();
    }

    @Override
    public Stream<Triple> stream(Triple tripleMatch) {
        MatchPattern pattern = PatternClassifier.classify(tripleMatch);
        switch (pattern) {
            case SUB_PRE_OBJ: {
                return this.triples.containsKey(tripleMatch) ? Stream.of(tripleMatch) : Stream.empty();
            }
            case SUB_ANY_ANY: 
            case ANY_PRE_ANY: 
            case ANY_ANY_OBJ: 
            case SUB_PRE_ANY: 
            case ANY_PRE_OBJ: 
            case SUB_ANY_OBJ: {
                return this.getBitmapForMatch(tripleMatch, pattern).stream().mapToObj(this.triples::getKeyAt);
            }
            case ANY_ANY_ANY: {
                return this.stream();
            }
        }
        throw new IllegalStateException("Unknown pattern classifier: " + PatternClassifier.classify(tripleMatch));
    }

    @Override
    public ExtendedIterator<Triple> find(Triple tripleMatch) {
        MatchPattern pattern = PatternClassifier.classify(tripleMatch);
        switch (pattern) {
            case SUB_PRE_OBJ: {
                return this.triples.containsKey(tripleMatch) ? new SingletonIterator<Triple>(tripleMatch) : NiceIterator.emptyIterator();
            }
            case SUB_ANY_ANY: 
            case ANY_PRE_ANY: 
            case ANY_ANY_OBJ: 
            case SUB_PRE_ANY: 
            case ANY_PRE_OBJ: 
            case SUB_ANY_OBJ: {
                return new RoaringBitmapTripleIterator(this.getBitmapForMatch(tripleMatch, pattern), this.triples);
            }
            case ANY_ANY_ANY: {
                return this.triples.keyIterator();
            }
        }
        throw new IllegalStateException("Unknown pattern classifier: " + PatternClassifier.classify(tripleMatch));
    }

    @Override
    public RoaringTripleStore copy() {
        return new RoaringTripleStore(this);
    }

    private static class NodesToBitmapsMap
    extends FastHashMap<Node, RoaringBitmap>
    implements Copyable<NodesToBitmapsMap> {
        public NodesToBitmapsMap() {
        }

        public NodesToBitmapsMap(NodesToBitmapsMap mapToCopy) {
            super(mapToCopy, RoaringBitmap::clone);
        }

        protected Node[] newKeysArray(int size) {
            return new Node[size];
        }

        protected RoaringBitmap[] newValuesArray(int size) {
            return new RoaringBitmap[size];
        }

        public NodesToBitmapsMap copy() {
            return new NodesToBitmapsMap(this);
        }
    }

    private static class TripleSet
    extends FastHashSet<Triple>
    implements Copyable<TripleSet> {
        public TripleSet() {
        }

        private TripleSet(FastHashSet<Triple> setToCopy) {
            super(setToCopy);
        }

        protected Triple[] newKeysArray(int size) {
            return new Triple[size];
        }

        public TripleSet copy() {
            return new TripleSet(this);
        }
    }
}

