/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.validation.event;

import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.validation.event.ValidationEvent;

public abstract class EventUtil {
    public static Stream<Class<? extends ValidationEvent>> getSuperclassesAndInterfaces(Class<? extends ValidationEvent> eventType) {
        Stream superInterfaces = Arrays.stream(eventType.getInterfaces()).filter(ValidationEvent.class::isAssignableFrom).flatMap(iface -> EventUtil.getSuperclassesAndInterfaces(iface));
        Class<? extends ValidationEvent> superType = eventType.getSuperclass();
        Stream<Object> superclasses = superType != null && ValidationEvent.class.isAssignableFrom(superType) ? EventUtil.getSuperclassesAndInterfaces(superType) : Stream.empty();
        return Stream.concat(superInterfaces, Stream.concat(superclasses, Stream.of(eventType)));
    }

    public static boolean nodeUriEquals(Node node, String uri) {
        if (node.isURI()) {
            return node.getURI().equals(uri);
        }
        return false;
    }
}

