/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import java.util.List;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.reasoner.BaseInfGraph;
import org.apache.jena.reasoner.IllegalParameterException;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.Util;
import org.apache.jena.vocabulary.ReasonerVocabulary;

public class BasicForwardRuleReasoner
implements Reasoner {
    protected ReasonerFactory factory;
    protected List<Rule> rules;
    protected InfGraph schemaGraph;
    protected boolean recordDerivations = false;
    protected boolean traceOn = false;
    protected Capabilities capabilities;

    public BasicForwardRuleReasoner(List<Rule> rules) {
        this.rules = rules;
    }

    public BasicForwardRuleReasoner(List<Rule> rules, ReasonerFactory factory) {
        this.rules = rules;
        this.factory = factory;
    }

    private BasicForwardRuleReasoner(List<Rule> rules, InfGraph schemaGraph, ReasonerFactory factory) {
        this.rules = rules;
        this.schemaGraph = schemaGraph;
        this.factory = factory;
    }

    @Override
    public Model getReasonerCapabilities() {
        if (this.factory != null) {
            return this.factory.getCapabilities();
        }
        return null;
    }

    @Override
    public void addDescription(Model configSpec, Resource base) {
    }

    @Override
    public boolean supportsProperty(Property property) {
        if (this.factory == null) {
            return false;
        }
        Model caps = this.factory.getCapabilities();
        Resource root = caps.getResource(this.factory.getURI());
        return caps.contains(root, ReasonerVocabulary.supportsP, property);
    }

    @Override
    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        BasicForwardRuleInfGraph graph = new BasicForwardRuleInfGraph(this, this.rules, null, tbox);
        return new BasicForwardRuleReasoner(this.rules, graph, this.factory);
    }

    @Override
    public Reasoner bindSchema(Model tbox) throws ReasonerException {
        BasicForwardRuleInfGraph graph = new BasicForwardRuleInfGraph(this, this.rules, null, tbox.getGraph());
        return new BasicForwardRuleReasoner(this.rules, graph, this.factory);
    }

    @Override
    public InfGraph bind(Graph data) throws ReasonerException {
        BasicForwardRuleInfGraph graph = new BasicForwardRuleInfGraph(this, this.rules, this.schemaGraph);
        graph.setDerivationLogging(this.recordDerivations);
        graph.setTraceOn(this.traceOn);
        graph.rebind(data);
        return graph;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    @Override
    public void setDerivationLogging(boolean logOn) {
        this.recordDerivations = logOn;
    }

    public void setTraceOn(boolean state) {
        this.traceOn = state;
    }

    @Override
    public void setParameter(Property parameter, Object value) {
        if (parameter.equals(ReasonerVocabulary.PROPderivationLogging)) {
            this.recordDerivations = Util.convertBooleanPredicateArg(parameter, value);
        } else if (parameter.equals(ReasonerVocabulary.PROPtraceOn)) {
            this.traceOn = Util.convertBooleanPredicateArg(parameter, value);
        } else {
            throw new IllegalParameterException("Don't recognize configuration parameter " + parameter + " for rule-based reasoner");
        }
    }

    @Override
    @Deprecated
    public Capabilities getGraphCapabilities() {
        return BaseInfGraph.reasonerInfCapabilities;
    }
}

