/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main;

import java.util.Iterator;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.SetUtils;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.OpVisitorBase;
import org.apache.jena.sparql.algebra.OpWalker;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.Op2;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpDiff;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLateral;
import org.apache.jena.sparql.algebra.op.OpList;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpModifier;
import org.apache.jena.sparql.algebra.op.OpN;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.main.VarFinder;

public class JoinClassifier {
    public static boolean print = false;
    private static OpVisitor checkForUnsafeVisitor = new OpVisitorBase(){

        @Override
        public void visit(OpMinus opMinus) {
            throw new UnsafeLinearOpException();
        }

        @Override
        public void visit(OpDiff opDiff) {
            throw new UnsafeLinearOpException();
        }
    };

    public static boolean isLinear(OpJoin join) {
        return JoinClassifier.isLinear(join.getLeft(), join.getRight());
    }

    public static boolean isLinear(Op _left, Op _right) {
        Op left = JoinClassifier.effectiveOp(_left);
        Op right = JoinClassifier.effectiveOp(_right);
        if (!JoinClassifier.isSafeForLinear(left) || !JoinClassifier.isSafeForLinear(right)) {
            return false;
        }
        if (right instanceof OpExtend) {
            return false;
        }
        if (right instanceof OpAssign) {
            return false;
        }
        if (right instanceof OpGroup) {
            return false;
        }
        if (right instanceof OpSlice) {
            return false;
        }
        if (right instanceof OpTopN) {
            return false;
        }
        if (right instanceof OpOrder) {
            return false;
        }
        if (right instanceof OpLateral) {
            return false;
        }
        Basis leftBasis = JoinClassifier.getBasis(left);
        Basis rightBasis = JoinClassifier.getBasis(right);
        if (leftBasis == Basis.TABLE && rightBasis == Basis.TABLE) {
            return false;
        }
        return JoinClassifier.check(left, right);
    }

    private static boolean isSafeForLinear(Op op) {
        try {
            OpWalker.walk(op, checkForUnsafeVisitor);
            return true;
        }
        catch (UnsafeLinearOpException e2) {
            return false;
        }
    }

    private static boolean check(Op leftOp, Op rightOp) {
        boolean bad1;
        if (print) {
            System.err.println("== JoinClassifier");
            System.err.println("Left::");
            System.err.println(leftOp);
            System.err.println("Right::");
            System.err.println(rightOp);
        }
        VarFinder vfLeft = VarFinder.process(leftOp);
        Set<Var> vLeftFixed = vfLeft.getFixed();
        Set vLeftOpt = vfLeft.getOpt();
        if (print) {
            System.err.println("Left");
            vfLeft.print(System.err);
        }
        VarFinder vfRight = VarFinder.process(rightOp);
        if (print) {
            System.err.println("Right");
            vfRight.print(System.err);
        }
        Set<Var> vRightFixed = vfRight.getFixed();
        Set vRightOpt = vfRight.getOpt();
        Set vRightFilter = vfRight.getFilter();
        Set<Var> vRightFilterOnly = vfRight.getFilterOnly();
        Set vRightAssign = vfRight.getAssign();
        if (!vRightFilterOnly.isEmpty() && (SetUtils.intersectionP(vLeftFixed, vRightFilterOnly) || SetUtils.intersectionP((Set)vLeftOpt, vRightFilterOnly))) {
            if (print) {
                System.err.println("vRightFilterOnly has variables used in the left");
            }
            return false;
        }
        vLeftOpt = SetUtils.difference(vLeftOpt, vLeftFixed);
        vRightOpt = SetUtils.difference(vRightOpt, vRightFixed);
        vRightFilter = SetUtils.difference(vRightFilter, vRightFixed);
        vRightAssign = SetUtils.difference(vRightAssign, vRightFixed);
        if (print) {
            System.err.println();
        }
        if (print) {
            System.err.println("Left/opt:      " + vLeftOpt);
        }
        if (print) {
            System.err.println("Right/opt:     " + vRightOpt);
        }
        if (print) {
            System.err.println("Right/filter:  " + vRightFilter);
        }
        if (print) {
            System.err.println("Right/assign:  " + vRightAssign);
        }
        boolean r11 = SetUtils.intersectionP((Set)vRightOpt, vLeftFixed);
        boolean r12 = SetUtils.intersectionP((Set)vRightOpt, (Set)vLeftOpt);
        boolean bl = bad1 = r11 || r12;
        if (print) {
            System.err.println("J: Case 1 (false=ok) = " + bad1);
        }
        if (bad1) {
            return false;
        }
        boolean bad2 = SetUtils.intersectionP((Set)vRightFilter, vLeftFixed);
        if (print) {
            System.err.println("J: Case 2 (false=ok) = " + bad2);
        }
        if (bad2) {
            return false;
        }
        boolean bad3 = SetUtils.intersectionP((Set)vRightAssign, vLeftFixed);
        if (print) {
            System.err.println("J: Case 3 (false=ok) = " + bad3);
        }
        if (bad3) {
            return false;
        }
        if (print) {
            System.err.println("J: Result: OK");
        }
        return true;
    }

    private static Op effectiveOp(Op op) {
        while (true) {
            if (op instanceof OpExt) {
                op = ((OpExt)op).effectiveOp();
                continue;
            }
            if (JoinClassifier.safeModifier(op)) {
                op = ((OpModifier)op).getSubOp();
                continue;
            }
            if (op instanceof OpGraph) {
                op = ((OpGraph)op).getSubOp();
                continue;
            }
            if (!(op instanceof OpService)) break;
            op = ((OpService)op).getSubOp();
        }
        return op;
    }

    private static boolean safeModifier(Op op) {
        if (!(op instanceof OpModifier)) {
            return false;
        }
        return op instanceof OpDistinct || op instanceof OpReduced || op instanceof OpProject || op instanceof OpList;
    }

    private static Basis getBasis(Op op) {
        Basis result;
        if (op instanceof OpTable) {
            result = Basis.TABLE;
        } else if (op instanceof OpPropFunc) {
            result = Basis.PFUNCTION;
        } else if (op instanceof OpExt) {
            Op effectiveOp = ((OpExt)op).effectiveOp();
            result = effectiveOp == null ? Basis.PATTERN : JoinClassifier.getBasis(effectiveOp);
        } else if (op instanceof Op1) {
            result = JoinClassifier.getBasis(((Op1)op).getSubOp());
        } else {
            Iterator<Op> it = JoinClassifier.getSubOps(op);
            if (!it.hasNext()) {
                result = Basis.PATTERN;
            } else {
                result = Basis.TABLE;
                while (it.hasNext()) {
                    Op subOp = it.next();
                    Basis contrib = JoinClassifier.getBasis(subOp);
                    if (contrib == Basis.PFUNCTION) {
                        contrib = Basis.TABLE;
                    }
                    if (contrib == Basis.TABLE) continue;
                    result = Basis.PATTERN;
                    break;
                }
            }
        }
        return result;
    }

    private static Iterator<Op> getSubOps(Op op) {
        if (op instanceof Op1) {
            return Iter.singletonIterator((Object)((Op1)op).getSubOp());
        }
        if (op instanceof Op2) {
            Op2 x = (Op2)op;
            return Iter.of((Object[])new Op[]{x.getLeft(), x.getRight()});
        }
        if (op instanceof OpN) {
            return ((OpN)op).iterator();
        }
        return Iter.empty();
    }

    private static enum Basis {
        PATTERN,
        TABLE,
        PFUNCTION;

    }

    private static class UnsafeLinearOpException
    extends RuntimeException {
        private UnsafeLinearOpException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

