/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.store.xloader;

import java.util.Iterator;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.tdb1.base.block.BlockMgr;
import org.apache.jena.tdb1.base.block.BlockMgrFactory;
import org.apache.jena.tdb1.base.file.FileSet;
import org.apache.jena.tdb1.base.file.Location;
import org.apache.jena.tdb1.base.record.Record;
import org.apache.jena.tdb1.base.record.RecordFactory;
import org.apache.jena.tdb1.index.RangeIndex;
import org.apache.jena.tdb1.index.SetupIndex;
import org.apache.jena.tdb1.index.bplustree.BPlusTree;
import org.apache.jena.tdb1.index.bplustree.BPlusTreeParams;
import org.apache.jena.tdb1.index.bplustree.BPlusTreeRewriter;

public class ProcRewriteIndex {
    public static void exec(Location srcLoc, Location dstLoc, String indexName) {
        int dftValueLength;
        int dftKeyLength;
        FileSet destination = new FileSet(dstLoc, indexName);
        int readCacheSize = 0;
        int writeCacheSize = -1;
        if (indexName.length() == 3) {
            dftKeyLength = 24;
            dftValueLength = 0;
        } else if (indexName.length() == 4) {
            dftKeyLength = 32;
            dftValueLength = 0;
        } else {
            FmtLog.error(ProcRewriteIndex.class, (String)"Can't determine record size for %s\n", (Object[])new Object[]{indexName});
            return;
        }
        RecordFactory recordFactory = null;
        BPlusTreeParams bptParams = null;
        int blockSize = 8192;
        RangeIndex rangeIndex = SetupIndex.makeRangeIndex(srcLoc, indexName, blockSize, dftKeyLength, dftValueLength, readCacheSize, writeCacheSize);
        BPlusTree bpt = (BPlusTree)rangeIndex;
        bptParams = bpt.getParams();
        recordFactory = bpt.getRecordFactory();
        int blockSizeNodes = blockSize;
        int blockSizeRecords = blockSize;
        BlockMgr blkMgrNodes = BlockMgrFactory.create(destination, "idn", blockSizeNodes, readCacheSize, writeCacheSize);
        BlockMgr blkMgrRecords = BlockMgrFactory.create(destination, "dat", blockSizeRecords, readCacheSize, writeCacheSize);
        Iterator<Record> iterator = bpt.iterator();
        BPlusTree bpt2 = BPlusTreeRewriter.packIntoBPlusTree(iterator, bptParams, recordFactory, blkMgrNodes, blkMgrRecords);
        if (bpt2 == null) {
            return;
        }
        bpt2.close();
    }
}

