/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.repositories;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.ontapi.GraphRepository;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.UnionGraph;
import org.apache.jena.ontapi.impl.repositories.OntUnionGraphListener;
import org.apache.jena.ontapi.utils.Graphs;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;

public class OntUnionGraphRepository {
    private final GraphRepository repository;
    private final Function<Graph, UnionGraph> unionGraphFactory;
    private final Function<Node, Graph> baseGraphFactory;
    private final boolean ignoreUnresolvedImports;

    public OntUnionGraphRepository(GraphRepository repository, Function<Graph, UnionGraph> unionGraphFactory, Function<Node, Graph> baseGraphFactory, boolean ignoreUnresolvedImports) {
        this.repository = repository;
        this.unionGraphFactory = unionGraphFactory;
        this.baseGraphFactory = baseGraphFactory;
        this.ignoreUnresolvedImports = ignoreUnresolvedImports;
    }

    protected static Graph getBase(Graph graph) {
        return OntUnionGraphRepository.getRaw(graph instanceof UnionGraph ? ((UnionGraph)graph).getBaseGraph() : graph);
    }

    protected static Graph getRaw(Graph graph) {
        if (graph instanceof InfGraph) {
            return ((InfGraph)graph).getRawGraph();
        }
        return graph;
    }

    protected static boolean graphEquals(Graph left, Graph right) {
        return left == right;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeUnusedImportSubGraphs(UnionGraph graph) {
        Set<String> imports = Graphs.getImports(graph.getBaseGraph());
        Set<Graph> delete = graph.subGraphs().filter(it -> {
            String uri = Graphs.findOntologyNameNode(OntUnionGraphRepository.getBase(it)).filter(Node::isURI).map(Node::getURI).orElse(null);
            return uri != null && !imports.contains(uri);
        }).collect(Collectors.toSet());
        UnionGraph.EventManager events = graph.getEventManager();
        try {
            events.off();
            delete.forEach(graph::removeSubGraph);
        }
        finally {
            events.on();
        }
    }

    public static Optional<Graph> findSubGraphByOntName(UnionGraph graph, Node name) {
        return graph.subGraphs().filter(it -> Graphs.findOntologyNameNode(OntUnionGraphRepository.getBase(it)).filter(arg_0 -> ((Node)name).equals(arg_0)).isPresent()).findFirst();
    }

    public static void checkIDCanBeChanged(UnionGraph graph) {
        Node name = Graphs.findOntologyNameNode(graph.getBaseGraph()).orElse(null);
        if (name == null || !name.isURI()) {
            return;
        }
        Set parents = graph.superGraphs().filter(it -> Graphs.hasImports(it.getBaseGraph(), name.getURI())).map(it -> Graphs.findOntologyNameNode(it.getBaseGraph()).filter(x -> !name.equals(x))).filter(Optional::isPresent).map(Optional::get).map(Node::toString).collect(Collectors.toSet());
        if (!parents.isEmpty()) {
            throw new OntJenaException.IllegalArgument("Can't change ontology ID <" + name + ">: it is used by <" + String.join((CharSequence)">, <", parents) + ">");
        }
    }

    public boolean contains(Node node) {
        return this.repository.contains(node.toString());
    }

    public UnionGraph get(Node name) {
        return this.putGraph(this.repositoryGet(name), name.toString());
    }

    public UnionGraph put(Graph graph) {
        return this.putGraph(graph, null);
    }

    public boolean remap(UnionGraph graph) {
        String newName = Graphs.findOntologyNameNode(OntUnionGraphRepository.getBase(graph)).map(Node::toString).orElse(null);
        if (newName != null && this.repository.contains(newName)) {
            return false;
        }
        String prevName = this.repository.ids().filter(name -> OntUnionGraphRepository.graphEquals(graph, this.repositoryGerOrNull((String)name))).findFirst().orElse(null);
        if (Objects.equals(newName, prevName)) {
            return false;
        }
        this.repository.remove(prevName);
        if (newName != null) {
            this.repository.put(newName, graph);
        }
        return true;
    }

    protected void remove(Node name) {
        this.repository.remove(name.toString());
    }

    protected UnionGraph putGraph(Graph root, String rootGraphId) {
        Node ontologyName = Graphs.findOntologyNameNode(OntUnionGraphRepository.getBase(root)).orElse(null);
        if (ontologyName == null) {
            throw new OntJenaException.IllegalArgument("Unnamed graph specified" + (String)(rootGraphId != null ? ", root graph = <" + rootGraphId + ">" : ""));
        }
        if (rootGraphId != null && !rootGraphId.equals(ontologyName.toString())) {
            throw new OntJenaException.IllegalState("Wrong mapping. Expected <" + rootGraphId + ">, but found <" + ontologyName + ">");
        }
        UnionGraph res = this.findOrPut(root, ontologyName);
        HashSet<UnionGraph> seen = new HashSet<UnionGraph>();
        ArrayDeque<UnionGraph> queue = new ArrayDeque<UnionGraph>();
        queue.add(res);
        while (!queue.isEmpty()) {
            Node currentName;
            UnionGraph current = (UnionGraph)queue.removeFirst();
            if (!seen.add(current) || (currentName = (Node)Graphs.findOntologyNameNode(current.getBaseGraph()).orElse(null)) == null) continue;
            UnionGraph parent = this.findOrPut(current, currentName);
            Graphs.getImports(parent.getBaseGraph()).forEach(uri -> {
                UnionGraph u = this.putSubGraph(parent, (String)uri);
                queue.add(u);
            });
            parent.superGraphs().forEach(queue::add);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnionGraph putSubGraph(UnionGraph parent, String uri) {
        UnionGraph u;
        Node name = NodeFactory.createURI((String)uri);
        Graph sub = OntUnionGraphRepository.findSubGraphByOntName(parent, name).orElse(null);
        if (OntUnionGraphRepository.graphEquals(sub, u = this.findOrPut(sub, name))) {
            return u;
        }
        UnionGraph.EventManager events = parent.getEventManager();
        try {
            events.off();
            if (sub != null) {
                parent.removeSubGraph(sub);
            }
            parent.addSubGraphIfAbsent(u);
        }
        finally {
            events.on();
        }
        return u;
    }

    protected UnionGraph findOrPut(Graph graph, Node ontologyName) {
        String graphId = ontologyName.toString();
        if (this.repository.contains(graphId)) {
            Graph found = this.repositoryGet(ontologyName);
            if (graph != null && !OntUnionGraphRepository.graphEquals(OntUnionGraphRepository.getBase(graph), OntUnionGraphRepository.getBase(found))) {
                throw new OntJenaException.IllegalArgument("Another graph with name <" + graphId + "> is already in the hierarchy");
            }
            graph = found;
        } else if (graph == null) {
            graph = this.newGraph(ontologyName);
        }
        graph = OntUnionGraphRepository.getRaw(graph);
        UnionGraph union = graph instanceof UnionGraph ? (UnionGraph)graph : this.unionGraphFactory.apply(graph);
        this.attachListener(union);
        this.repository.put(graphId, union);
        return union;
    }

    protected Graph repositoryGet(Node name) {
        try {
            return this.repository.get(name.toString());
        }
        catch (Exception ex) {
            if (this.ignoreUnresolvedImports) {
                Graph res = this.newGraph(name);
                this.repository.put(name.toString(), res);
                return res;
            }
            throw ex;
        }
    }

    private Graph repositoryGerOrNull(String name) {
        try {
            return this.repository.get(name);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Graph newGraph(Node name) {
        Graph res = this.baseGraphFactory.apply(name);
        res.add(name, RDF.type.asNode(), OWL2.Ontology.asNode());
        return res;
    }

    protected void attachListener(UnionGraph res) {
        UnionGraph.EventManager manager = res.getEventManager();
        if (manager.listeners(OntUnionGraphListener.class).noneMatch(it -> this.isSameRepository(it.ontGraphRepository))) {
            manager.register(new OntUnionGraphListener(this));
        }
    }

    protected boolean isSameRepository(OntUnionGraphRepository repository) {
        return this.repository == repository.repository;
    }
}

