/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.factories;

import java.util.Set;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontapi.impl.objects.OntAnnotationImpl;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.ontapi.utils.StdModels;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;

final class OntAnnotations {
    public static final Set<Node> REQUIRED_PROPERTY_NODES = StdModels.asUnmodifiableNodeSet(OntAnnotationImpl.REQUIRED_PROPERTIES);
    public static final Node AXIOM = OWL2.Axiom.asNode();
    public static final Node ANNOTATION = OWL2.Annotation.asNode();
    public static final Set<Node> EXTRA_ROOT_TYPES_AS_NODES = StdModels.asUnmodifiableNodeSet(OntAnnotationImpl.EXTRA_ROOT_TYPES);

    OntAnnotations() {
    }

    public static ExtendedIterator<Node> listRootAnnotations(EnhGraph eg) {
        return Iterators.flatMap(Iterators.of(AXIOM).andThen(EXTRA_ROOT_TYPES_AS_NODES.iterator()), t -> eg.asGraph().find(Node.ANY, RDF.Nodes.type, t)).mapWith(Triple::getSubject);
    }

    public static boolean testAnnotation(Node node, EnhGraph graph) {
        return OntAnnotations.testAnnotation(node, graph.asGraph());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testAnnotation(Node node, Graph graph) {
        if (!node.isBlank()) {
            return false;
        }
        try (ExtendedIterator types = graph.find(node, RDF.Nodes.type, Node.ANY).mapWith(Triple::getObject);){
            while (types.hasNext()) {
                Node t = (Node)types.next();
                if (AXIOM.equals((Object)t) || ANNOTATION.equals((Object)t)) {
                    Set props = graph.find(node, Node.ANY, Node.ANY).mapWith(Triple::getPredicate).toSet();
                    boolean bl = props.containsAll(REQUIRED_PROPERTY_NODES);
                    return bl;
                }
                if (!EXTRA_ROOT_TYPES_AS_NODES.contains(t)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

