/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.util.iterator.ExtendedIterator;

public interface EnhNodeFactory {
    public static Implementation asJenaImplementation(EnhNodeFactory f) throws OntJenaException {
        if (f instanceof Implementation) {
            return (Implementation)f;
        }
        return (Implementation)OntJenaException.TODO("The given EnhNodeFactory is not an instance of Jena Implementation.");
    }

    public ExtendedIterator<EnhNode> iterator(EnhGraph var1);

    public boolean canWrap(Node var1, EnhGraph var2);

    public EnhNode createInstance(Node var1, EnhGraph var2);

    default public EnhNode wrap(Node node, EnhGraph eg) {
        if (!this.canWrap(node, eg)) {
            throw new OntJenaException.Conversion("Can't wrap node " + node + ". Use direct factory.");
        }
        return this.createInstance(node, eg);
    }

    default public EnhNode createInGraph(Node node, EnhGraph eg) {
        throw new OntJenaException.IllegalCall("Creation is not allowed: " + node);
    }

    default public boolean canCreateInGraph(Node node, EnhGraph eg) {
        return false;
    }

    default public Stream<EnhNode> find(EnhGraph eg) {
        return Iterators.asStream(this.iterator(eg));
    }
}

