/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.writers.WriterExpr;
import org.apache.jena.sparql.util.ExprUtils;

public abstract class AggregatorBase
implements Aggregator {
    protected final String name;
    protected final boolean isDistinct;
    protected final ExprList exprList;
    private Map<Binding, Accumulator> buckets = new HashMap<Binding, Accumulator>();
    protected static final int HC_AggAvg = 368;
    protected static final int HC_AggAvgDistinct = 369;
    protected static final int HC_AggCount = 370;
    protected static final int HC_AggCountDistinct = 371;
    protected static final int HC_AggCountVar = 372;
    protected static final int HC_AggCountVarDistinct = 373;
    protected static final int HC_AggMin = 374;
    protected static final int HC_AggMinDistinct = 375;
    protected static final int HC_AggMax = 376;
    protected static final int HC_AggMaxDistinct = 377;
    protected static final int HC_AggSample = 378;
    protected static final int HC_AggSampleDistinct = 379;
    protected static final int HC_AggSum = 380;
    protected static final int HC_AggSumDistinct = 381;
    protected static final int HC_AggGroupConcat = 382;
    protected static final int HC_AggGroupConcatDistinct = 383;
    protected static final int HC_AggNull = 384;
    protected static final int HC_AggCustom = 385;
    protected static final int HC_AggMedian = 386;
    protected static final int HC_AggMedianDistinct = 387;
    protected static final int HC_AggMode = 388;
    protected static final int HC_AggModeDistinct = 389;

    protected AggregatorBase(String name, boolean isDistinct, Expr expr) {
        this(name, isDistinct, new ExprList(expr));
    }

    protected AggregatorBase(String name, boolean isDistinct, ExprList exprList) {
        this.name = name;
        this.isDistinct = isDistinct;
        this.exprList = exprList;
    }

    @Override
    public abstract Accumulator createAccumulator();

    @Override
    public abstract Node getValueEmpty();

    public Node getValue(Binding key) {
        Accumulator acc = this.buckets.get(key);
        if (acc == null) {
            throw new ARQInternalErrorException("Null for accumulator");
        }
        NodeValue nv = acc.getValue();
        if (nv == null) {
            return null;
        }
        return nv.asNode();
    }

    @Override
    public String key() {
        return this.toPrefixString();
    }

    @Override
    public final Aggregator copyTransform(NodeTransform transform) {
        ExprList e2 = this.getExprList();
        if (e2 != null) {
            e2 = e2.applyNodeTransform(transform);
        }
        return this.copy(e2);
    }

    protected Expr getExpr() {
        if (this.exprList != null && this.exprList.size() == 1) {
            return this.getExprList().get(0);
        }
        return null;
    }

    @Override
    public ExprList getExprList() {
        return this.exprList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.asSparqlExpr(null);
    }

    @Override
    public String asSparqlExpr(SerializationContext sCxt) {
        IndentedLineBuffer x = new IndentedLineBuffer();
        x.append(this.getName(), new Object[0]);
        x.append("(", new Object[0]);
        if (this.isDistinct) {
            x.append("DISTINCT ", new Object[0]);
        }
        if (this.getExprList() != null) {
            ExprUtils.fmtSPARQL((IndentedWriter)x, this.getExprList(), sCxt);
        }
        x.append(")", new Object[0]);
        return x.asString();
    }

    @Override
    public String toPrefixString() {
        IndentedLineBuffer x = new IndentedLineBuffer();
        x.append("(", new Object[0]);
        x.append(Lib.lowercase((String)this.getName()), new Object[0]);
        x.incIndent();
        if (this.isDistinct) {
            x.append(" distinct", new Object[0]);
        }
        for (Expr e2 : this.getExprList()) {
            x.append(" ", new Object[0]);
            WriterExpr.output((IndentedWriter)x, e2, null);
        }
        x.decIndent();
        x.append(")", new Object[0]);
        return x.asString();
    }

    @Override
    public abstract int hashCode();

    @Override
    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof Aggregator)) {
            return false;
        }
        return this.equals((Aggregator)other, false);
    }
}

