/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.objects;

import java.util.Optional;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.impl.objects.OntObjectImpl;
import org.apache.jena.ontapi.model.OntFacetRestriction;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;

public abstract class OntFacetRestrictionImpl
extends OntObjectImpl
implements OntFacetRestriction {
    public OntFacetRestrictionImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    private static Property predicate(Class<?> view) {
        if (OntFacetRestriction.Length.class.equals(view)) {
            return XSD.length;
        }
        if (OntFacetRestriction.MinLength.class.equals(view)) {
            return XSD.minLength;
        }
        if (OntFacetRestriction.MaxLength.class.equals(view)) {
            return XSD.maxLength;
        }
        if (OntFacetRestriction.MinInclusive.class.equals(view)) {
            return XSD.minInclusive;
        }
        if (OntFacetRestriction.MaxInclusive.class.equals(view)) {
            return XSD.maxInclusive;
        }
        if (OntFacetRestriction.MinExclusive.class.equals(view)) {
            return XSD.minExclusive;
        }
        if (OntFacetRestriction.MaxExclusive.class.equals(view)) {
            return XSD.maxExclusive;
        }
        if (OntFacetRestriction.TotalDigits.class.equals(view)) {
            return XSD.totalDigits;
        }
        if (OntFacetRestriction.FractionDigits.class.equals(view)) {
            return XSD.fractionDigits;
        }
        if (OntFacetRestriction.Pattern.class.equals(view)) {
            return XSD.pattern;
        }
        if (OntFacetRestriction.LangRange.class.equals(view)) {
            return RDF.langRange;
        }
        throw new OntJenaException.IllegalArgument("Unsupported facet restriction " + view);
    }

    public static <T extends OntFacetRestriction> T create(OntGraphModelImpl model, Class<T> view, Literal literal) {
        Resource res = model.createResource();
        res.addProperty(OntFacetRestrictionImpl.predicate(view), (RDFNode)literal);
        return (T)((OntFacetRestriction)model.getNodeAs(res.asNode(), view));
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return Optional.of(this.getModel().createStatement(this, OntFacetRestrictionImpl.predicate(this.objectType()), (RDFNode)this.getValue()));
    }

    @Override
    public Literal getValue() {
        return this.getRequiredObject(OntFacetRestrictionImpl.predicate(this.objectType()), Literal.class);
    }

    public static class LangRangeImpl
    extends OntFacetRestrictionImpl
    implements OntFacetRestriction.LangRange {
        public LangRangeImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.LangRange> objectType() {
            return OntFacetRestriction.LangRange.class;
        }
    }

    public static class FractionDigitsImpl
    extends OntFacetRestrictionImpl
    implements OntFacetRestriction.FractionDigits {
        public FractionDigitsImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.FractionDigits> objectType() {
            return OntFacetRestriction.FractionDigits.class;
        }
    }

    public static class TotalDigitsImpl
    extends OntFacetRestrictionImpl
    implements OntFacetRestriction.TotalDigits {
        public TotalDigitsImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.TotalDigits> objectType() {
            return OntFacetRestriction.TotalDigits.class;
        }
    }

    public static class PatternImpl
    extends OntFacetRestrictionImpl
    implements OntFacetRestriction.Pattern {
        public PatternImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.Pattern> objectType() {
            return OntFacetRestriction.Pattern.class;
        }
    }

    public static class MaxExclusiveImpl
    extends OntFacetRestrictionImpl
    implements OntFacetRestriction.MaxExclusive {
        public MaxExclusiveImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.MaxExclusive> objectType() {
            return OntFacetRestriction.MaxExclusive.class;
        }
    }

    public static class MinExclusiveImpl
    extends OntFacetRestrictionImpl
    implements OntFacetRestriction.MinExclusive {
        public MinExclusiveImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.MinExclusive> objectType() {
            return OntFacetRestriction.MinExclusive.class;
        }
    }

    public static class MaxInclusiveImpl
    extends OntFacetRestrictionImpl
    implements OntFacetRestriction.MaxInclusive {
        public MaxInclusiveImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.MaxInclusive> objectType() {
            return OntFacetRestriction.MaxInclusive.class;
        }
    }

    public static class MinInclusiveImpl
    extends OntFacetRestrictionImpl
    implements OntFacetRestriction.MinInclusive {
        public MinInclusiveImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.MinInclusive> objectType() {
            return OntFacetRestriction.MinInclusive.class;
        }
    }

    public static class MaxLengthImpl
    extends OntFacetRestrictionImpl
    implements OntFacetRestriction.MaxLength {
        public MaxLengthImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.MaxLength> objectType() {
            return OntFacetRestriction.MaxLength.class;
        }
    }

    public static class MinLengthImpl
    extends OntFacetRestrictionImpl
    implements OntFacetRestriction.MinLength {
        public MinLengthImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.MinLength> objectType() {
            return OntFacetRestriction.MinLength.class;
        }
    }

    public static class LengthImpl
    extends OntFacetRestrictionImpl
    implements OntFacetRestriction.Length {
        public LengthImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public Class<OntFacetRestriction.Length> objectType() {
            return OntFacetRestriction.Length.class;
        }
    }
}

