/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.store.legacy;

import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem2.store.TripleStore;
import org.apache.jena.mem2.store.legacy.NodeToTriplesMap;
import org.apache.jena.mem2.store.legacy.NodeToTriplesMapMem;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.util.iterator.SingletonIterator;

public class LegacyTripleStore
implements TripleStore {
    private final NodeToTriplesMap subjects;
    private final NodeToTriplesMap predicates;
    private final NodeToTriplesMap objects;

    public LegacyTripleStore() {
        this.subjects = new NodeToTriplesMapMem(Triple.Field.fieldSubject, Triple.Field.fieldPredicate, Triple.Field.fieldObject);
        this.predicates = new NodeToTriplesMapMem(Triple.Field.fieldPredicate, Triple.Field.fieldObject, Triple.Field.fieldSubject);
        this.objects = new NodeToTriplesMapMem(Triple.Field.fieldObject, Triple.Field.fieldSubject, Triple.Field.fieldPredicate);
    }

    private LegacyTripleStore(LegacyTripleStore toCopy) {
        this.subjects = toCopy.subjects.copy();
        this.predicates = toCopy.predicates.copy();
        this.objects = toCopy.objects.copy();
    }

    @Override
    public void add(Triple triple) {
        if (this.subjects.tryAdd(triple)) {
            this.predicates.addUnchecked(triple);
            this.objects.addUnchecked(triple);
        }
    }

    @Override
    public void remove(Triple triple) {
        if (this.subjects.tryRemove(triple)) {
            this.predicates.removeUnchecked(triple);
            this.objects.removeUnchecked(triple);
        }
    }

    @Override
    public void clear() {
        this.subjects.clear();
        this.predicates.clear();
        this.objects.clear();
    }

    @Override
    public int countTriples() {
        return this.subjects.size();
    }

    @Override
    public boolean isEmpty() {
        return this.subjects.isEmpty();
    }

    @Override
    public boolean contains(Triple tripleMatch) {
        if (tripleMatch.isConcrete()) {
            return this.subjects.containsKey(tripleMatch);
        }
        Node pm = tripleMatch.getPredicate();
        Node om = tripleMatch.getObject();
        Node sm = tripleMatch.getSubject();
        if (sm.isConcrete()) {
            return this.subjects.containsMatch(sm, pm, om);
        }
        if (om.isConcrete()) {
            return this.objects.containsMatch(om, sm, pm);
        }
        if (pm.isConcrete()) {
            return this.predicates.containsMatch(pm, om, sm);
        }
        return !this.isEmpty();
    }

    @Override
    public Stream<Triple> stream() {
        return this.subjects.keyStream();
    }

    @Override
    public Stream<Triple> stream(Triple tripleMatch) {
        if (tripleMatch.isConcrete()) {
            return this.subjects.containsKey(tripleMatch) ? Stream.of(tripleMatch) : Stream.empty();
        }
        Node pm = tripleMatch.getPredicate();
        Node om = tripleMatch.getObject();
        Node sm = tripleMatch.getSubject();
        if (sm.isConcrete()) {
            return this.subjects.streamForMatches(sm, pm, om);
        }
        if (om.isConcrete()) {
            return this.objects.streamForMatches(om, sm, pm);
        }
        if (pm.isConcrete()) {
            return this.predicates.streamForMatches(pm, om, sm);
        }
        return this.subjects.keyStream();
    }

    @Override
    public ExtendedIterator<Triple> find(Triple tripleMatch) {
        if (tripleMatch.isConcrete()) {
            return this.subjects.containsKey(tripleMatch) ? new SingletonIterator<Triple>(tripleMatch) : NiceIterator.emptyIterator();
        }
        Node pm = tripleMatch.getPredicate();
        Node om = tripleMatch.getObject();
        Node sm = tripleMatch.getSubject();
        if (sm.isConcrete()) {
            return this.subjects.iteratorForMatches(sm, pm, om);
        }
        if (om.isConcrete()) {
            return this.objects.iteratorForMatches(om, sm, pm);
        }
        if (pm.isConcrete()) {
            return this.predicates.iteratorForMatches(pm, om, sm);
        }
        return this.subjects.keyIterator();
    }

    @Override
    public LegacyTripleStore copy() {
        return new LegacyTripleStore(this);
    }
}

