/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.impl;

import java.util.Arrays;
import java.util.Objects;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.RDFhtml;
import org.apache.jena.datatypes.xsd.impl.RDFjson;
import org.apache.jena.datatypes.xsd.impl.XMLLiteralType;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.graph.impl.LiteralValue;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.JenaParameters;
import org.apache.jena.vocabulary.RDF;

public final class LiteralLabel {
    private String lexicalForm;
    private String lang;
    private TextDirection textDir;
    private RDFDatatype dtype;
    private Object value;
    private static ValueMode valueMode = ValueMode.EAGER;
    private boolean wellformed = true;
    private Exception exception = null;
    private final int hash;
    private volatile Object value1 = null;
    private static Object invalidValue = new Object();

    LiteralLabel(String lex, RDFDatatype dtype) {
        this(lex, "", null, dtype);
    }

    LiteralLabel(String lex, String lang, TextDirection textDir, RDFDatatype dtype) {
        this.lexicalForm = lex;
        this.dtype = Objects.requireNonNull(dtype);
        this.lang = lang;
        this.textDir = textDir;
        this.hash = this.calcHashCode();
        if (valueMode == ValueMode.EAGER) {
            this.wellformed = this.setValue(lex, dtype);
            dtype = LiteralLabel.normalize(this.value, dtype);
        } else {
            this.value = null;
        }
    }

    private static String indexingLang(String lang) {
        return lang;
    }

    LiteralLabel(Object value) {
        this(value, LiteralValue.datatypeForValueAny(value));
    }

    LiteralLabel(Object value, RDFDatatype dtype) throws DatatypeFormatException {
        this.dtype = dtype;
        this.lang = "";
        if (value instanceof String) {
            String lex;
            this.lexicalForm = lex = (String)value;
            this.wellformed = this.setValue(lex, dtype);
            dtype = LiteralLabel.normalize(value, dtype);
            this.hash = this.calcHashCode();
            return;
        }
        this.value = dtype == null ? value : dtype.cannonicalise(value);
        this.dtype = LiteralLabel.normalize(value, dtype);
        this.wellformed = this.dtype.isValidValue(value);
        if (JenaParameters.enableEagerLiteralValidation && !this.wellformed) {
            throw new DatatypeFormatException(value.toString(), dtype, "in literal creation");
        }
        this.lexicalForm = dtype == null ? value.toString() : dtype.unparse(value);
        this.hash = this.calcHashCode();
    }

    private boolean setValue(String lex, RDFDatatype dtype) throws DatatypeFormatException {
        try {
            this.value = dtype.parse(lex);
            return true;
        }
        catch (DatatypeFormatException e) {
            if (JenaParameters.enableEagerLiteralValidation) {
                e.fillInStackTrace();
                throw e;
            }
            this.exception = e;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getValueLazy() {
        if (this.value != null) {
            return this.value;
        }
        if (this.value1 != null) {
            return this.value1;
        }
        LiteralLabel literalLabel = this;
        synchronized (literalLabel) {
            if (this.value1 == null) {
                this.value1 = this.calcValue(this.lexicalForm);
            }
        }
        this.value = this.value1 != invalidValue ? this.value1 : null;
        return this.value1;
    }

    private Object calcValue(String lex) {
        try {
            Object v = this.dtype.parse(lex);
            this.wellformed = true;
            this.dtype = this.dtype.normalizeSubType(v, this.dtype);
            return v;
        }
        catch (DatatypeFormatException e) {
            this.wellformed = false;
            return invalidValue;
        }
    }

    protected static RDFDatatype normalize(Object value, RDFDatatype datatype) {
        if (datatype != null && value != null) {
            return datatype.normalizeSubType(value, datatype);
        }
        return datatype;
    }

    public boolean isWellFormed() {
        return this.dtype != null && this.isWellFormedRaw();
    }

    private boolean isWellFormedRaw() {
        if (!this.wellformed) {
            return false;
        }
        this.getValueInternal();
        return this.wellformed;
    }

    public String toString(boolean quoting) {
        return this.toString(PrefixMapping.Standard, quoting);
    }

    public String toString(PrefixMapping pmap, boolean quoting) {
        StringBuilder b = new StringBuilder();
        if (!quoting && this.simpleLiteral()) {
            return this.getLexicalForm();
        }
        quoting = true;
        if (quoting) {
            b.append('\"');
        }
        String elex = EscapeStr.stringEsc((String)this.getLexicalForm());
        b.append(elex);
        if (quoting) {
            b.append('\"');
        }
        if (this.lang != null && !this.lang.equals("")) {
            b.append("@").append(this.lang);
        } else if (!this.dtype.equals(XSDDatatype.XSDstring)) {
            String dtStr = pmap != null ? PrefixMapping.Standard.shortForm(this.dtype.getURI()) : this.dtype.getURI();
            b.append("^^").append(dtStr);
        }
        return b.toString();
    }

    private boolean simpleLiteral() {
        return this.dtype.equals(XSDDatatype.XSDstring);
    }

    public String toString() {
        return this.toString(true);
    }

    public String getLexicalForm() {
        return this.lexicalForm;
    }

    public Object getIndexingValue() {
        if (this.indexingValueIsSelf()) {
            return this;
        }
        if (!this.lang.equals("")) {
            return this.getLexicalForm() + "@" + LiteralLabel.indexingLang(this.lang);
        }
        if (this.wellformed) {
            Object value = this.getValue();
            if (value instanceof byte[]) {
                return new ByteArray((byte[])value);
            }
            return value;
        }
        return this.getLexicalForm();
    }

    private boolean indexingValueIsSelf() {
        return this.dtype == XMLLiteralType.theXMLLiteralType || this.dtype == RDFjson.rdfJSON || this.dtype == RDFhtml.rdfHTML;
    }

    public String language() {
        return this.lang;
    }

    public TextDirection initialTextDirection() {
        return this.textDir;
    }

    public Object getValue() throws DatatypeFormatException {
        Object val = this.getValueInternal();
        if (!this.wellformed) {
            throw new DatatypeFormatException(this.lexicalForm, this.dtype, (Throwable)null);
        }
        if (val != null) {
            return val;
        }
        if (!JenaParameters.enableEagerLiteralValidation) {
            throw new DatatypeFormatException();
        }
        return null;
    }

    private Object getValueInternal() {
        Object v = this.getValueLazy();
        return v == invalidValue ? null : v;
    }

    public RDFDatatype getDatatype() {
        return this.dtype;
    }

    public String getDatatypeURI() {
        if (this.dtype == null) {
            return null;
        }
        return this.dtype.getURI();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof LiteralLabel)) {
            return false;
        }
        LiteralLabel otherLiteral = (LiteralLabel)other;
        boolean typeEquals = Objects.equals(this.dtype, otherLiteral.getDatatype());
        if (!typeEquals) {
            return false;
        }
        boolean lexEquals = Objects.equals(this.getLexicalForm(), otherLiteral.getLexicalForm());
        if (!lexEquals) {
            return false;
        }
        boolean langEquals = Objects.equals(this.lang, otherLiteral.language());
        return langEquals;
    }

    public boolean sameValueAs(LiteralLabel other) {
        return LiteralLabel.sameValueAs(this, other);
    }

    private static boolean sameValueAs(LiteralLabel lit1, LiteralLabel lit2) {
        if (lit1 == null) {
            throw new NullPointerException();
        }
        if (lit2 == null) {
            throw new NullPointerException();
        }
        if (LiteralLabel.isStringValue(lit1) && LiteralLabel.isStringValue(lit2)) {
            return lit1.getLexicalForm().equals(lit2.getLexicalForm());
        }
        if (LiteralLabel.isStringValue(lit1)) {
            return false;
        }
        if (LiteralLabel.isStringValue(lit2)) {
            return false;
        }
        if (LiteralLabel.isLangString(lit1) && LiteralLabel.isLangString(lit2)) {
            String lex2;
            String lex1 = lit1.getLexicalForm();
            return lex1.equals(lex2 = lit2.getLexicalForm()) && lit1.language().equalsIgnoreCase(lit2.language());
        }
        if (LiteralLabel.isLangString(lit1)) {
            return false;
        }
        if (LiteralLabel.isLangString(lit2)) {
            return false;
        }
        if (LiteralLabel.isLangStringDir(lit1) && LiteralLabel.isLangStringDir(lit2)) {
            String lex2;
            String lex1 = lit1.getLexicalForm();
            return lex1.equals(lex2 = lit2.getLexicalForm()) && lit1.language().equalsIgnoreCase(lit2.language()) && lit1.initialTextDirection().equals((Object)lit2.initialTextDirection());
        }
        if (LiteralLabel.isLangStringDir(lit1)) {
            return false;
        }
        if (LiteralLabel.isLangStringDir(lit2)) {
            return false;
        }
        if (lit1.isWellFormedRaw() && lit2.isWellFormedRaw()) {
            return lit1.getDatatype().isEqual(lit1, lit2);
        }
        if (!lit1.isWellFormedRaw() && !lit2.isWellFormedRaw()) {
            return lit1.equals(lit2);
        }
        return false;
    }

    private static boolean isStringValue(LiteralLabel lit) {
        if (lit.getDatatype() == null) {
            return !LiteralLabel.isLangString(lit);
        }
        return lit.getDatatype().equals(XSDDatatype.XSDstring);
    }

    private static boolean isLangString(LiteralLabel lit) {
        if (Lib.isEmpty((CharSequence)lit.language())) {
            return false;
        }
        if (lit.initialTextDirection() != null) {
            return false;
        }
        if (!Objects.equals(lit.getDatatype(), RDF.dtLangString)) {
            throw new JenaException("Literal with language string which is not rdf:langString: " + lit);
        }
        return true;
    }

    private static boolean isLangStringDir(LiteralLabel lit) {
        String lang = lit.language();
        if (lit.initialTextDirection() == null) {
            return false;
        }
        if (!Objects.equals(lit.getDatatype(), RDF.dtDirLangString)) {
            throw new JenaException("Literal with language string and text direction which is not rdf:dirLangString: " + lit);
        }
        return true;
    }

    private int calcHashCode() {
        return Objects.hash(this.lexicalForm, this.lang, this.dtype);
    }

    public int hashCode() {
        return this.hash;
    }

    public int getValueHashCode() {
        if (this.indexingValueIsSelf()) {
            return this.hashCode();
        }
        Object v = this.getValueInternal();
        if (!this.wellformed) {
            return this.hashCode();
        }
        if (!this.wellformed) {
            return this.hashCode();
        }
        return v.hashCode();
    }

    private static enum ValueMode {
        EAGER,
        LAZY;

    }

    static class ByteArray {
        private int hashCode = 0;
        private final byte[] bytes;

        ByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int prime = 31;
                int result = 1;
                this.hashCode = 31 * result + Arrays.hashCode(this.bytes);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ByteArray other = (ByteArray)obj;
            return Arrays.equals(this.bytes, other.bytes);
        }
    }
}

