/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.datatypes.xsd.impl;

import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.shared.impl.JenaParameters;

public class XSDFloat
extends XSDDatatype {
    public XSDFloat(String typeName) {
        super(typeName);
    }

    public XSDFloat(String typeName, Class<?> javaClass) {
        super(typeName, javaClass);
    }

    @Override
    public boolean isValidValue(Object valueForm) {
        return valueForm instanceof Float;
    }

    @Override
    public Object parse(String lexicalForm) throws DatatypeFormatException {
        this.checkWhitespace(lexicalForm);
        return super.parse(lexicalForm);
    }

    @Override
    public String unparse(Object value) {
        if (value instanceof Float) {
            Float f = (Float)value;
            if (Float.isInfinite(f.floatValue())) {
                if (f.floatValue() < 0.0f) {
                    return "-INF";
                }
                return "INF";
            }
            return f.toString();
        }
        return super.unparse(value);
    }

    @Override
    public Object parseValidated(String lex) {
        switch (lex) {
            case "INF": {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            case "+INF": {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            case "-INF": {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            case "NaN": {
                return Float.valueOf(Float.NaN);
            }
        }
        return Float.valueOf(lex);
    }

    protected void checkWhitespace(String lexicalForm) {
        if (JenaParameters.enableWhitespaceCheckingOfTypedLiterals && !lexicalForm.trim().equals(lexicalForm)) {
            throw new DatatypeFormatException(lexicalForm, (RDFDatatype)this, "whitespace violation");
        }
    }

    @Override
    public boolean isEqual(LiteralLabel value1, LiteralLabel value2) {
        return value1.getDatatype() == value2.getDatatype() && value1.getValue().equals(value2.getValue());
    }
}

