/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.dboe.base.file.FileException;

public class ChannelManager {
    private static Map<String, FileChannel> name2channel = new HashMap<String, FileChannel>();
    private static Map<FileChannel, String> channel2name = new HashMap<FileChannel, String>();

    public static FileChannel acquire(String filename) {
        return ChannelManager.acquire(filename, "rw");
    }

    public static FileChannel acquire(String filename, String mode) {
        return ChannelManager.openref$(filename, mode);
    }

    private static FileChannel openref$(String filename, String mode) {
        if (!filename.endsWith(".jrnl")) {
            return ChannelManager.open$(filename, mode);
        }
        FileChannel chan = name2channel.get(filename);
        if (chan != null) {
            throw new FileException("Already open: " + filename);
        }
        chan = ChannelManager.open$(filename, mode);
        name2channel.put(filename, chan);
        channel2name.put(chan, filename);
        return chan;
    }

    private static FileChannel open$(String filename, String mode) {
        try {
            RandomAccessFile out = new RandomAccessFile(filename, mode);
            FileChannel channel = out.getChannel();
            return channel;
        }
        catch (IOException ex) {
            throw new FileException("Failed to open: " + filename + " (mode=" + mode + ")", ex);
        }
    }

    public static void release(String filename) {
        FileChannel channel = name2channel.get(filename);
        if (channel != null) {
            ChannelManager.release(channel);
        }
    }

    public static void release(FileChannel chan) {
        try {
            chan.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String name = channel2name.remove(chan);
        if (name != null) {
            name2channel.remove(name);
        }
    }

    public static void reset() {
        ChannelManager.releaseAll(null);
    }

    public static void releaseAll(String prefix) {
        ArrayList<FileChannel> x = new ArrayList<FileChannel>();
        for (String fn : name2channel.keySet()) {
            if (prefix != null && !fn.startsWith(prefix)) continue;
            x.add(name2channel.get(fn));
        }
        for (FileChannel chan : x) {
            ChannelManager.release(chan);
        }
    }
}

