/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.block;

import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.block.BlockException;
import org.apache.jena.dboe.base.block.BlockMgrBase;
import org.apache.jena.dboe.base.file.BlockAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlockMgrFileAccess
extends BlockMgrBase {
    private static Logger log = LoggerFactory.getLogger(BlockMgrFileAccess.class);
    private final BlockAccess file;
    private boolean closed = false;
    private boolean syncNeeded = false;

    BlockMgrFileAccess(BlockAccess blockAccess, int blockSize) {
        super(blockAccess.getLabel(), blockSize);
        this.file = blockAccess;
    }

    @Override
    protected Block allocate() {
        this.syncNeeded = true;
        return this.file.allocate(this.blockSize);
    }

    @Override
    public Block promote(Block block) {
        return block;
    }

    @Override
    public Block getRead(long id) {
        return this.getBlock(id, true);
    }

    @Override
    public Block getWrite(long id) {
        return this.getBlock(id, false);
    }

    private Block getBlock(long id, boolean readOnly) {
        this.checkNotClosed();
        Block block = this.file.read(id);
        block.setReadOnly(readOnly);
        return block;
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new InternalErrorException(Lib.className((Object)this) + " : already closed");
        }
    }

    @Override
    public void release(Block block) {
        this.checkNotClosed();
    }

    @Override
    public void write(Block block) {
        this.checkNotClosed();
        if (block.isReadOnly()) {
            throw new BlockException("Attempt to write a read-only block (" + block.getId() + ")");
        }
        this.syncNeeded = true;
        this.file.write(block);
    }

    @Override
    public void overwrite(Block block) {
        this.checkNotClosed();
        this.syncNeeded = true;
        this.file.overwrite(block);
    }

    @Override
    public void free(Block block) {
        this.checkNotClosed();
    }

    @Override
    public boolean valid(int id) {
        this.checkNotClosed();
        return this.file.valid(id);
    }

    @Override
    public void sync() {
        this.checkNotClosed();
        if (this.syncNeeded) {
            this.file.sync();
        } else {
            this.syncNeeded = true;
        }
        this.syncNeeded = false;
    }

    @Override
    public void syncForce() {
        this.checkNotClosed();
        this.file.sync();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
        this.file.close();
    }

    @Override
    public boolean isEmpty() {
        this.checkNotClosed();
        return this.file.isEmpty();
    }

    @Override
    public long allocLimit() {
        this.checkNotClosed();
        return this.file.allocBoundary();
    }

    @Override
    public void resetAlloc(long boundary) {
        this.checkNotClosed();
        this.file.resetAllocBoundary(boundary);
    }

    public String toString() {
        return String.format("BlockMgrFileAccess[%d bytes]:%s", this.blockSize, this.file);
    }

    @Override
    protected Logger log() {
        return log;
    }
}

