/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.impl;

import java.util.Objects;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.impl.AdhocDatatype;

class LiteralValue {
    LiteralValue() {
    }

    static Object calculateValue(String lexicalForm, RDFDatatype dtype) {
        Objects.requireNonNull(lexicalForm, "Lexical form");
        Objects.requireNonNull(dtype, "Datatype");
        try {
            Object value = dtype.parse(lexicalForm);
            return value;
        }
        catch (DatatypeFormatException ex) {
            return null;
        }
    }

    static RDFDatatype datatypeForValue(Object value) {
        return TypeMapper.getInstance().getTypeByValue(value);
    }

    static RDFDatatype datatypeForValueAny(Object value) {
        RDFDatatype dt = LiteralValue.datatypeForValue(value);
        if (dt != null) {
            return dt;
        }
        dt = LiteralValue.inventDatatypeForValue(value);
        return dt;
    }

    private static RDFDatatype inventDatatypeForValue(Object value) {
        Class<?> c = value.getClass();
        Log.warn(LiteralValue.class, (String)("Inventing a datatype for " + c));
        AdhocDatatype dt = new AdhocDatatype(c);
        TypeMapper.getInstance().registerDatatype(dt);
        return dt;
    }
}

