/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.store;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.NullIterator;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.tdb1.lib.TupleLib;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.TableBase;
import org.apache.jena.tdb1.store.nodetable.NodeTable;
import org.apache.jena.tdb1.store.tupletable.TupleIndex;
import org.apache.jena.tdb1.sys.DatasetControl;

public class TripleTable
extends TableBase {
    public TripleTable(TupleIndex[] indexes, NodeTable nodeTable, DatasetControl policy) {
        super(3, indexes, nodeTable, policy);
    }

    public boolean add(Triple triple) {
        return this.add(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean add(Node s, Node p, Node o) {
        return this.table.addRow(s, p, o);
    }

    public boolean delete(Triple triple) {
        return this.delete(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean delete(Node s, Node p, Node o) {
        return this.table.deleteRow(s, p, o);
    }

    public Iterator<Triple> find(Node s, Node p, Node o) {
        Iterator<Tuple<NodeId>> iter = this.table.findAsNodeIds(s, p, o);
        if (iter == null) {
            return new NullIterator();
        }
        Iterator<Triple> iter2 = TupleLib.convertToTriples(this.table.getNodeTable(), iter);
        return iter2;
    }

    public void clearTriples() {
        this.table.clear();
    }
}

