/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.ref;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDiff;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLabel;
import org.apache.jena.sparql.algebra.op.OpLateral;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpList;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProcedure;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuad;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.ref.Evaluator;
import org.apache.jena.sparql.engine.ref.RefEval;
import org.apache.jena.sparql.exec.http.Service;

public class EvaluatorDispatch
implements OpVisitor {
    private Deque<Table> stack = new ArrayDeque<Table>();
    protected Evaluator evaluator;

    public EvaluatorDispatch(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    protected Table eval(Op op) {
        op.visit(this);
        return this.pop();
    }

    Table getResult() {
        if (this.stack.size() != 1) {
            Log.warn((Object)this, (String)("Warning: getResult: stack size = " + this.stack.size()));
        }
        Table table = this.pop();
        return table;
    }

    @Override
    public void visit(OpBGP opBGP) {
        Table table = this.evaluator.basicPattern(opBGP.getPattern());
        this.push(table);
    }

    @Override
    public void visit(OpQuadPattern quadPattern) {
        this.push(RefEval.evalQuadPattern(quadPattern, this.evaluator));
    }

    @Override
    public void visit(OpQuadBlock quadBlock) {
        this.push(this.eval(quadBlock.convertOp()));
    }

    @Override
    public void visit(OpTriple opTriple) {
        this.visit(opTriple.asBGP());
    }

    @Override
    public void visit(OpQuad opQuad) {
        this.visit(opQuad.asQuadPattern());
    }

    @Override
    public void visit(OpPath opPath) {
        Table table = this.evaluator.pathPattern(opPath.getTriplePath());
        this.push(table);
    }

    @Override
    public void visit(OpProcedure opProc) {
        Table table = this.eval(opProc.getSubOp());
        table = this.evaluator.procedure(table, opProc.getProcId(), opProc.getArgs());
        this.push(table);
    }

    @Override
    public void visit(OpPropFunc opPropFunc) {
        Table table = this.eval(opPropFunc.getSubOp());
        table = this.evaluator.propertyFunction(table, opPropFunc.getProperty(), opPropFunc.getSubjectArgs(), opPropFunc.getObjectArgs());
        this.push(table);
    }

    @Override
    public void visit(OpJoin opJoin) {
        Table left = this.eval(opJoin.getLeft());
        Table right = this.eval(opJoin.getRight());
        Table table = this.evaluator.join(left, right);
        this.push(table);
    }

    @Override
    public void visit(OpSequence opSequence) {
        Table table = TableFactory.createUnit();
        Iterator<Op> iter = opSequence.iterator();
        while (iter.hasNext()) {
            Op op = iter.next();
            Table eltTable = this.eval(op);
            table = this.evaluator.join(table, eltTable);
        }
        this.push(table);
    }

    @Override
    public void visit(OpDisjunction opDisjunction) {
        Table table = TableFactory.createEmpty();
        Iterator<Op> iter = opDisjunction.iterator();
        while (iter.hasNext()) {
            Op op = iter.next();
            Table eltTable = this.eval(op);
            table = this.evaluator.union(table, eltTable);
        }
        this.push(table);
    }

    @Override
    public void visit(OpLeftJoin opLeftJoin) {
        Table left = this.eval(opLeftJoin.getLeft());
        Table right = this.eval(opLeftJoin.getRight());
        try {
            left.rows();
        }
        catch (Throwable th) {
            Op x = opLeftJoin.getLeft();
            this.eval(x);
            System.out.println("NULL");
        }
        Table table = this.evaluator.leftJoin(left, right, opLeftJoin.getExprs());
        this.push(table);
    }

    @Override
    public void visit(OpDiff opDiff) {
        Table left = this.eval(opDiff.getLeft());
        Table right = this.eval(opDiff.getRight());
        Table table = this.evaluator.diff(left, right);
        this.push(table);
    }

    @Override
    public void visit(OpMinus opMinus) {
        Table left = this.eval(opMinus.getLeft());
        Table right = this.eval(opMinus.getRight());
        Table table = this.evaluator.minus(left, right);
        this.push(table);
    }

    @Override
    public void visit(OpUnion opUnion) {
        Table left = this.eval(opUnion.getLeft());
        Table right = this.eval(opUnion.getRight());
        Table table = this.evaluator.union(left, right);
        this.push(table);
    }

    @Override
    public void visit(OpConditional opCond) {
        Table left = this.eval(opCond.getLeft());
        Table right = this.eval(opCond.getRight());
        Table table = this.evaluator.condition(left, right);
        this.push(table);
    }

    @Override
    public void visit(OpLateral opLateral) {
        Table left = this.eval(opLateral.getLeft());
        Table table = this.evaluator.lateral(left, opLateral.getRight());
        this.push(table);
    }

    @Override
    public void visit(OpFilter opFilter) {
        Table table = this.eval(opFilter.getSubOp());
        table = this.evaluator.filter(opFilter.getExprs(), table);
        this.push(table);
    }

    @Override
    public void visit(OpGraph opGraph) {
        this.push(RefEval.evalGraph(opGraph, this.evaluator));
    }

    @Override
    public void visit(OpService opService) {
        QueryIterator qIter = Service.exec(opService, ARQ.getContext());
        Table table = TableFactory.create(qIter);
        this.push(table);
    }

    @Override
    public void visit(OpDatasetNames dsNames) {
        this.push(RefEval.evalDS(dsNames, this.evaluator));
    }

    @Override
    public void visit(OpTable opTable) {
        this.push(opTable.getTable());
    }

    @Override
    public void visit(OpExt opExt) {
        throw new QueryExecException("Encountered OpExt during execution of reference engine");
    }

    @Override
    public void visit(OpNull opNull) {
        this.push(TableFactory.createEmpty());
    }

    @Override
    public void visit(OpLabel opLabel) {
        if (opLabel.hasSubOp()) {
            this.push(this.eval(opLabel.getSubOp()));
        } else {
            this.push(TableFactory.createUnit());
        }
    }

    @Override
    public void visit(OpList opList) {
        Table table = this.eval(opList.getSubOp());
        table = this.evaluator.list(table);
        this.push(table);
    }

    @Override
    public void visit(OpOrder opOrder) {
        Table table = this.eval(opOrder.getSubOp());
        table = this.evaluator.order(table, opOrder.getConditions());
        this.push(table);
    }

    @Override
    public void visit(OpTopN opTop) {
        Table table = this.eval(opTop.getSubOp());
        table = this.evaluator.order(table, opTop.getConditions());
        table = this.evaluator.slice(table, 0L, opTop.getLimit());
        this.push(table);
    }

    @Override
    public void visit(OpProject opProject) {
        Table table = this.eval(opProject.getSubOp());
        table = this.evaluator.project(table, opProject.getVars());
        this.push(table);
    }

    @Override
    public void visit(OpDistinct opDistinct) {
        Table table = this.eval(opDistinct.getSubOp());
        table = this.evaluator.distinct(table);
        this.push(table);
    }

    @Override
    public void visit(OpReduced opReduced) {
        Table table = this.eval(opReduced.getSubOp());
        table = this.evaluator.reduced(table);
        this.push(table);
    }

    @Override
    public void visit(OpSlice opSlice) {
        Table table = this.eval(opSlice.getSubOp());
        table = this.evaluator.slice(table, opSlice.getStart(), opSlice.getLength());
        this.push(table);
    }

    @Override
    public void visit(OpAssign opAssign) {
        Table table = this.eval(opAssign.getSubOp());
        table = this.evaluator.assign(table, opAssign.getVarExprList());
        this.push(table);
    }

    @Override
    public void visit(OpExtend opExtend) {
        Table table = this.eval(opExtend.getSubOp());
        table = this.evaluator.extend(table, opExtend.getVarExprList());
        this.push(table);
    }

    @Override
    public void visit(OpGroup opGroup) {
        Table table = this.eval(opGroup.getSubOp());
        table = this.evaluator.groupBy(table, opGroup.getGroupVars(), opGroup.getAggregators());
        this.push(table);
    }

    protected void push(Table table) {
        this.stack.push(table);
    }

    protected Table pop() {
        if (this.stack.size() == 0) {
            Log.warn((Object)this, (String)"Warning: pop: empty stack");
        }
        Table table = this.stack.pop();
        return table;
    }
}

