/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset.rw;

import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.rowset.RowSetWriter;
import org.apache.jena.riot.rowset.RowSetWriterFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.Context;

public class RowSetWriterTSV
implements RowSetWriter {
    public static RowSetWriterFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.RS_TSV)) {
            throw new ResultSetException("RowSetWriter for TSV asked for a " + lang);
        }
        return new RowSetWriterTSV();
    };
    private static final String NL = "\n";
    private static final String SEP = "\t";
    private static final String headerBytes = "?_askResult\n";
    private static final String yesString = "true";
    private static final String noString = "false";

    private RowSetWriterTSV() {
    }

    @Override
    public void write(OutputStream out, RowSet rowSet, Context context2) {
        RowSetWriterTSV.output(IO.wrapUTF8((OutputStream)out), rowSet);
    }

    @Override
    public void write(Writer out, RowSet rowSet, Context context2) {
        RowSetWriterTSV.output(IO.wrap((Writer)out), rowSet);
    }

    @Override
    public void write(OutputStream out, boolean result, Context context2) {
        RowSetWriterTSV.output(IO.wrapUTF8((OutputStream)out), result);
    }

    private static void output(AWriter out, boolean booleanResult) {
        try {
            out.write(headerBytes);
            if (booleanResult) {
                out.write(yesString);
            } else {
                out.write(noString);
            }
            out.write(NL);
        }
        finally {
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void output(AWriter out, RowSet rowSet) {
        try {
            NodeFormatter formatter = RowSetWriterTSV.createNodeFormatter();
            String sep = null;
            List<Var> vars = rowSet.getResultVars();
            for (Var var : vars) {
                if (sep != null) {
                    out.write(sep);
                } else {
                    sep = SEP;
                }
                out.write("?");
                out.write(var.getVarName());
            }
            out.write(NL);
            while (rowSet.hasNext()) {
                sep = null;
                Binding b = rowSet.next();
                for (Var v : vars) {
                    if (sep != null) {
                        out.write(sep);
                    }
                    sep = SEP;
                    Node n = b.get(v);
                    if (n == null) continue;
                    formatter.format(out, n);
                }
                out.write(NL);
            }
        }
        finally {
            out.flush();
        }
    }

    protected static NodeFormatter createNodeFormatter() {
        return new NodeFormatterTTL(null, null);
    }
}

