/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.process.normalize;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.process.normalize.DatatypeHandler;
import org.apache.jena.riot.process.normalize.NormalizeValue;
import org.apache.jena.riot.web.LangTag;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.vocabulary.RDF;

public class CanonicalizeLiteral
implements Function<Node, Node> {
    private static final CanonicalizeLiteral singleton = new CanonicalizeLiteral();
    private static final RDFDatatype dtPlainLiteral = NodeFactory.getType((String)(RDF.getURI() + "PlainLiteral"));
    private static final Map<RDFDatatype, DatatypeHandler> dispatch = new HashMap<RDFDatatype, DatatypeHandler>();

    public static CanonicalizeLiteral get() {
        return singleton;
    }

    private CanonicalizeLiteral() {
    }

    @Override
    public Node apply(Node node) {
        Node n2;
        if (!node.isLiteral()) {
            return node;
        }
        if (!node.getLiteralDatatype().isValid(node.getLiteralLexicalForm())) {
            return node;
        }
        RDFDatatype dt = node.getLiteralDatatype();
        if (NodeUtils.isLangString(node)) {
            if (node.getLiteralLanguage().equals("")) {
                return node;
            }
            n2 = CanonicalizeLiteral.canonicalLangtag(node.getLiteralLexicalForm(), node.getLiteralLanguage());
        } else if (dt == null) {
            n2 = NormalizeValue.dtSimpleLiteral.handle(node, node.getLiteralLexicalForm(), null);
        } else {
            DatatypeHandler handler = dispatch.get(dt);
            if (handler == null) {
                return node;
            }
            n2 = handler.handle(node, node.getLiteralLexicalForm(), dt);
        }
        if (n2 == null) {
            return node;
        }
        return n2;
    }

    public static Node canonicalValue(Node node) {
        if (!node.isLiteral()) {
            return node;
        }
        if (NodeUtils.isLangString(node)) {
            return node;
        }
        if (NodeUtils.isSimpleString(node)) {
            return node;
        }
        if (!node.getLiteralDatatype().isValid(node.getLiteralLexicalForm())) {
            return node;
        }
        RDFDatatype dt = node.getLiteralDatatype();
        DatatypeHandler handler = dispatch.get(dt);
        if (handler == null) {
            return node;
        }
        Node n2 = handler.handle(node, node.getLiteralLexicalForm(), dt);
        if (n2 == null) {
            return node;
        }
        return n2;
    }

    private static Node canonicalLangtag(String lexicalForm, String langTag) {
        String langTag2 = LangTag.canonical(langTag);
        if (langTag2.equals(langTag)) {
            return null;
        }
        return NodeFactory.createLiteralLang((String)lexicalForm, (String)langTag2);
    }

    static {
        dispatch.put((RDFDatatype)XSDDatatype.XSDinteger, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDdecimal, NormalizeValue.dtDecimal);
        dispatch.put((RDFDatatype)XSDDatatype.XSDint, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDlong, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDshort, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDbyte, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDunsignedInt, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDunsignedLong, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDunsignedShort, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDunsignedByte, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDnonPositiveInteger, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDnonNegativeInteger, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDpositiveInteger, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDnegativeInteger, NormalizeValue.dtInteger);
        dispatch.put((RDFDatatype)XSDDatatype.XSDfloat, NormalizeValue.dtFloat);
        dispatch.put((RDFDatatype)XSDDatatype.XSDdouble, NormalizeValue.dtDouble);
        dispatch.put((RDFDatatype)XSDDatatype.XSDdateTime, NormalizeValue.dtDateTime);
        dispatch.put((RDFDatatype)XSDDatatype.XSDduration, null);
        dispatch.put((RDFDatatype)XSDDatatype.XSDboolean, NormalizeValue.dtBoolean);
        dispatch.put((RDFDatatype)XSDDatatype.XSDstring, NormalizeValue.dtXSDString);
        dispatch.put(dtPlainLiteral, NormalizeValue.dtPlainLiteral);
    }
}

