/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.solver;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.tdb1.solver.BindingNodeId;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.nodetable.NodeTable;
import org.apache.jena.tdb1.store.nodetupletable.NodeTupleTable;

class StageMatchTuple {
    private static Function<Tuple<NodeId>, Tuple<NodeId>> quadsToAnyTriples = item -> TupleFactory.create4((Object)NodeId.NodeIdAny, (Object)((NodeId)item.get(1)), (Object)((NodeId)item.get(2)), (Object)((NodeId)item.get(3)));

    StageMatchTuple() {
    }

    static Iterator<BindingNodeId> access(NodeTupleTable nodeTupleTable, Iterator<BindingNodeId> input, Tuple<Node> patternTuple, Predicate<Tuple<NodeId>> filter, boolean anyGraph, ExecutionContext execCxt) {
        return Iter.flatMap(input, bnid -> StageMatchTuple.access(nodeTupleTable, bnid, patternTuple, filter, anyGraph, execCxt));
    }

    private static Iterator<BindingNodeId> access(NodeTupleTable nodeTupleTable, BindingNodeId input, Tuple<Node> patternTuple, Predicate<Tuple<NodeId>> filter, boolean anyGraph, ExecutionContext execCxt) {
        Object[] ids = new NodeId[patternTuple.len()];
        Var[] vars = new Var[patternTuple.len()];
        boolean b = StageMatchTuple.prepare(nodeTupleTable.getNodeTable(), patternTuple, input, (NodeId[])ids, vars);
        if (!b) {
            return Iter.nullIterator();
        }
        Iterator iterMatches = nodeTupleTable.find((Tuple<NodeId>)TupleFactory.create((Object[])ids));
        if (filter != null) {
            iterMatches = Iter.filter(iterMatches, filter);
        }
        if (anyGraph) {
            iterMatches = Iter.map((Iterator)iterMatches, quadsToAnyTriples);
            iterMatches = Iter.distinctAdjacent((Iterator)iterMatches);
        }
        Function<Tuple, BindingNodeId> binder = tuple -> StageMatchTuple.tupleToBinding(input, (Tuple<NodeId>)tuple, vars);
        return Iter.iter((Iterator)iterMatches).map(binder).removeNulls();
    }

    private static BindingNodeId tupleToBinding(BindingNodeId input, Tuple<NodeId> tuple, Var[] var) {
        BindingNodeId output = new BindingNodeId(input);
        for (int i = 0; i < var.length; ++i) {
            Var v = var[i];
            if (v == null) continue;
            NodeId id = (NodeId)tuple.get(i);
            if (!StageMatchTuple.compatible(output, v, id)) {
                return null;
            }
            output.put(v, id);
        }
        return output;
    }

    private static boolean prepare(NodeTable nodeTable, Tuple<Node> patternTuple, BindingNodeId input, NodeId[] ids, Var[] var) {
        for (int i = 0; i < patternTuple.len(); ++i) {
            Node n = (Node)patternTuple.get(i);
            NodeId nId = StageMatchTuple.idFor(nodeTable, input, n);
            if (NodeId.isDoesNotExist(nId)) {
                return false;
            }
            ids[i] = nId;
            if (nId != null) continue;
            var[i] = StageMatchTuple.asVar(n);
        }
        return true;
    }

    private static Iterator<Tuple<NodeId>> print(Iterator<Tuple<NodeId>> iter) {
        if (!iter.hasNext()) {
            System.err.println("<empty>");
        } else {
            List r = Iter.toList(iter);
            String str = StrUtils.strjoin((List)r, (String)"\n");
            System.err.println(str);
            iter = Iter.iter((Collection)r);
        }
        return iter;
    }

    private static boolean compatible(BindingNodeId output, Var var, NodeId value) {
        if (!output.containsKey(var)) {
            return true;
        }
        return ((NodeId)output.get(var)).equals(value);
    }

    private static Var asVar(Node node) {
        if (Var.isVar((Node)node)) {
            return Var.alloc((Node)node);
        }
        return null;
    }

    private static NodeId idFor(NodeTable nodeTable, BindingNodeId input, Node node) {
        if (Var.isVar((Node)node)) {
            NodeId n = (NodeId)input.get(Var.alloc((Node)node));
            return n;
        }
        return nodeTable.getNodeIdForNode(node);
    }
}

