/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.sys;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.dboe.base.file.ChannelManager;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.base.file.ProcessFileLock;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.dboe.transaction.txn.TransactionException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.tdb2.params.StoreParams;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.TDB2StorageBuilder;
import org.apache.jena.tdb2.sys.SystemTDB;

public class StoreConnection {
    private static Map<Location, StoreConnection> cache = new ConcurrentHashMap<Location, StoreConnection>();
    private final DatasetGraphTDB datasetGraph;
    private final Location location;
    private final ProcessFileLock lock;
    private boolean isValid = true;
    private volatile boolean haveUsedInTransaction = false;

    public static synchronized StoreConnection connectCreate(Location location) {
        return StoreConnection.connectCreate(location, null, null);
    }

    public static synchronized StoreConnection connectCreate(Location location, StoreParams params, ReorderTransformation reorderTransform) {
        return StoreConnection.make(location, params, reorderTransform);
    }

    public static synchronized StoreConnection connectExisting(Location location) {
        StoreConnection sConn = cache.get(location);
        return sConn;
    }

    public static synchronized boolean isSetup(Location location) {
        return cache.containsKey(location);
    }

    private static synchronized StoreConnection make(Location location, StoreParams params, ReorderTransformation reorderTransform) {
        StoreConnection sConn = cache.get(location);
        if (sConn == null) {
            ProcessFileLock lock = null;
            if (!location.isMem()) {
                lock = StoreConnection.lockForLocation(location);
                lock.lockEx();
            }
            DatasetGraphTDB dsg = TDB2StorageBuilder.build(location, params, reorderTransform);
            sConn = new StoreConnection(dsg, lock);
            if (!location.isMemUnique()) {
                cache.put(location, sConn);
            }
        }
        return sConn;
    }

    public static synchronized void internalReset() {
        Set<Location> x = Set.copyOf(cache.keySet());
        for (Location loc : x) {
            StoreConnection.internalExpel(loc, true);
        }
        cache.clear();
        ChannelManager.reset();
    }

    public static synchronized void release(Location location) {
        StoreConnection.internalExpel(location, false);
    }

    public static synchronized void internalExpel(Location location, boolean force) {
        StoreConnection sConn = cache.get(location);
        if (sConn == null) {
            return;
        }
        TransactionCoordinator txnCoord = sConn.getDatasetGraphTDB().getTxnSystem().getTxnMgr();
        if (!force && txnCoord.countActive() > 0L) {
            throw new TransactionException("Can't expel: Active transactions for location: " + location);
        }
        sConn.getDatasetGraphTDB().shutdown();
        sConn.isValid = false;
        cache.remove(location);
        if (!location.isMem()) {
            if (!sConn.lock.isLockedHere()) {
                SystemTDB.errlog.warn("Location " + location.getDirectoryPath() + " was not locked by this process.");
            }
            sConn.lock.unlock();
            ProcessFileLock.release((ProcessFileLock)sConn.lock);
        }
    }

    public static ProcessFileLock lockForLocation(Location location) {
        FileOps.ensureDir((String)location.getDirectoryPath());
        String lockFilename = location.getPath("tdb.lock");
        Path path = Path.of(lockFilename, new String[0]);
        try {
            path.toFile().createNewFile();
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
            return null;
        }
        return ProcessFileLock.create((String)lockFilename);
    }

    private StoreConnection(DatasetGraphTDB dsg, ProcessFileLock fileLock) {
        this.datasetGraph = dsg;
        this.location = dsg.getLocation();
        this.lock = fileLock;
    }

    public DatasetGraph getDatasetGraph() {
        return this.datasetGraph;
    }

    public DatasetGraphTDB getDatasetGraphTDB() {
        return this.datasetGraph;
    }

    public Location getLocation() {
        return this.location;
    }

    public ProcessFileLock getLock() {
        return this.lock;
    }
}

