/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.logging.Log;

public final class CacheCaffeine<K, V>
implements Cache<K, V> {
    private static boolean WITH_STATS = false;
    private BiConsumer<K, V> dropHandler = null;
    private com.github.benmanes.caffeine.cache.Cache<K, V> cache;
    private final int size;

    public CacheCaffeine(int size) {
        this(size, null);
    }

    public CacheCaffeine(int size, BiConsumer<K, V> dropHandler) {
        Caffeine builder = Caffeine.newBuilder().maximumSize((long)size).initialCapacity(size / 4).executor(c -> c.run());
        if (dropHandler != null) {
            RemovalListener drop = (key, value, cause) -> {
                if (dropHandler != null) {
                    dropHandler.accept(key, value);
                }
            };
            builder = builder.removalListener(drop);
        }
        if (WITH_STATS) {
            builder = builder.recordStats();
        }
        this.cache = builder.build();
        this.size = size;
    }

    public CacheCaffeine(com.github.benmanes.caffeine.cache.Cache<K, V> caffeine) {
        this.cache = caffeine;
        this.size = -1;
    }

    @Override
    public V getOrFill(K key, Callable<V> filler) {
        return (V)this.cache.get(key, k -> CacheCaffeine.call(filler));
    }

    private static <X> X call(Callable<X> filler) {
        try {
            return filler.call();
        }
        catch (Exception e) {
            Log.warn(CacheCaffeine.class, "Execution exception filling cache", e);
            return null;
        }
    }

    @Override
    public V get(K key, Function<K, V> f) {
        return (V)this.cache.get(key, f);
    }

    @Override
    public V getIfPresent(K key) {
        return (V)this.cache.getIfPresent(key);
    }

    @Override
    public void put(K key, V thing) {
        if (thing == null) {
            this.cache.invalidate(key);
        } else {
            this.cache.put(key, thing);
        }
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.getIfPresent(key) != null;
    }

    @Override
    public void remove(K key) {
        this.cache.invalidate(key);
    }

    @Override
    public Iterator<K> keys() {
        return this.cache.asMap().keySet().iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.estimatedSize() == 0L;
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public long size() {
        return this.cache.estimatedSize();
    }
}

