/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.filelog.rotate;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.rdfpatch.filelog.rotate.FileMgr;
import org.apache.jena.rdfpatch.filelog.rotate.FileRotateException;
import org.apache.jena.rdfpatch.filelog.rotate.Filename;
import org.apache.jena.rdfpatch.filelog.rotate.Roller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RollerTimestamp
implements Roller {
    private static final Logger LOG = LoggerFactory.getLogger(RollerTimestamp.class);
    private final Path directory;
    private final String baseFilename;
    private Path currentFilename = null;
    private boolean valid = false;
    private LocalDateTime lastTimestamp = null;
    private Path lastAllocatedPath = null;
    private static final Pattern patternFilenameDateTime = Pattern.compile("(.*)(-)(\\d{4}-\\d{2}-\\d{2}_\\d{2}-\\d{2}-\\d{2}(?:\\.\\d+)?)");
    private static final String DATETIME_SEP = "-";
    private static final DateTimeFormatter fmtDateTime = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
    private static final Comparator<Filename> cmpDateTime = (x, y) -> {
        LocalDateTime xdt = RollerTimestamp.filenameToDateTime(x);
        LocalDateTime ydt = RollerTimestamp.filenameToDateTime(y);
        return xdt.compareTo(ydt);
    };
    private static int RETRIES = 5;

    private static LocalDateTime filenameToDateTime(Filename filename) {
        return LocalDateTime.parse(filename.modifier, fmtDateTime);
    }

    RollerTimestamp(Path directory, String baseFilename) {
        this.directory = directory;
        this.baseFilename = baseFilename;
        this.init(directory, baseFilename);
    }

    private void init(Path directory, String baseFilename) {
        LocalDateTime current = LocalDateTime.now();
        List<Filename> filenames = FileMgr.scan(directory, baseFilename, patternFilenameDateTime);
        if (filenames.isEmpty()) {
            this.currentFilename = null;
        } else {
            LocalDateTime dtLast = RollerTimestamp.filenameToDateTime(Collections.max(filenames, cmpDateTime));
            LocalDateTime dtFirst = RollerTimestamp.filenameToDateTime(Collections.min(filenames, cmpDateTime));
            int problems = 0;
            if (dtLast.isAfter(current)) {
                ++problems;
                FmtLog.warn((Logger)LOG, (String)"Latest output file is timestamped after now: %s > %s", (Object[])new Object[]{dtLast, current});
            }
            if (dtFirst.isAfter(current)) {
                ++problems;
                FmtLog.warn((Logger)LOG, (String)"First output file is timestamped after now: %s > %s", (Object[])new Object[]{dtFirst, current});
            }
            if (problems > 0) {
                throw new FileRotateException("Existing files timestamped into the future");
            }
            this.currentFilename = this.filename(dtLast);
        }
    }

    @Override
    public Stream<Filename> files() {
        List<Filename> filenames = FileMgr.scan(this.directory, this.baseFilename, patternFilenameDateTime);
        return filenames.stream().sorted(cmpDateTime);
    }

    @Override
    public Path directory() {
        return this.directory;
    }

    @Override
    public void startSection() {
    }

    @Override
    public void finishSection() {
    }

    @Override
    public Path latestFilename() {
        return this.lastAllocatedPath;
    }

    @Override
    public boolean hasExpired() {
        return !this.valid;
    }

    @Override
    public void rotate() {
        this.valid = false;
    }

    @Override
    public Path nextFilename() {
        int i = 1;
        while (true) {
            LocalDateTime timestamp;
            String fn;
            Path path;
            if (!Files.exists(path = this.directory.resolve(fn = this.baseFilename + DATETIME_SEP + (timestamp = LocalDateTime.now()).format(fmtDateTime)), new LinkOption[0])) {
                this.valid = true;
                this.lastTimestamp = timestamp;
                this.lastAllocatedPath = path;
                return this.lastAllocatedPath;
            }
            if (i == RETRIES) {
                throw new FileRotateException("Failed to find a new, fresh filename: " + timestamp);
            }
            Lib.sleep((int)1000);
            ++i;
        }
    }

    private Path filename(LocalDateTime dateTime) {
        String fn = this.baseFilename + DATETIME_SEP + dateTime.format(fmtDateTime);
        return this.directory.resolve(fn);
    }
}

