/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecutionAdapter;
import org.apache.jena.sparql.resultset.RDFOutput;
import org.apache.jena.sparql.resultset.ResultsFormat;
import org.apache.jena.sparql.resultset.ResultsWriter;
import org.apache.jena.sparql.util.Context;

public class QueryExecUtils {
    protected static PrefixMapping globalPrefixMap = new PrefixMappingImpl();
    protected static Prologue dftPrologue;

    public static void exec(Query query, DatasetGraph dsg) {
        QueryExec qExec = QueryExec.dataset(dsg).query(query).build();
        QueryExecUtils.exec(qExec);
    }

    public static void exec(QueryExec queryExec) {
        QueryExecUtils.exec((Prologue)queryExec.getQuery(), queryExec);
    }

    public static void exec(Prologue prologue, QueryExec queryExec) {
        QueryExecUtils.exec(prologue, queryExec, ResultsFormat.FMT_TEXT);
    }

    public static void exec(Prologue prologue, QueryExec queryExec, ResultsFormat outputFormat) {
        QueryExecUtils.exec(prologue, queryExec, outputFormat, System.out);
    }

    public static void exec(Prologue prologue, QueryExec queryExec, ResultsFormat outputFormat, PrintStream output) {
        QueryExecution queryExecution = QueryExecutionAdapter.adapt(queryExec);
        QueryExecUtils.executeQuery(prologue, queryExecution, outputFormat, output);
    }

    public static void executeQuery(QueryExecution queryExecution) {
        QueryExecUtils.executeQuery(null, queryExecution);
    }

    public static void executeQuery(Prologue prologue, QueryExecution queryExecution) {
        QueryExecUtils.executeQuery(prologue, queryExecution, ResultsFormat.FMT_TEXT);
    }

    public static void executeQuery(Prologue prologue, QueryExecution queryExecution, ResultsFormat outputFormat) {
        QueryExecUtils.executeQuery(prologue, queryExecution, outputFormat, System.out);
    }

    public static void executeQuery(Prologue prologue, QueryExecution queryExecution, ResultsFormat outputFormat, PrintStream output) {
        Query query = queryExecution.getQuery();
        if (prologue == null && query != null) {
            prologue = query.getPrologue();
        }
        if (prologue == null) {
            prologue = dftPrologue;
        }
        if (query.isSelectType()) {
            QueryExecUtils.doSelectQuery(prologue, queryExecution, outputFormat, output);
        } else if (query.isDescribeType()) {
            QueryExecUtils.doDescribeQuery(prologue, queryExecution, outputFormat, output);
        } else if (query.isConstructQuad()) {
            QueryExecUtils.doConstructQuadsQuery(prologue, queryExecution, outputFormat, output);
        } else if (query.isConstructType()) {
            QueryExecUtils.doConstructQuery(prologue, queryExecution, outputFormat, output);
        } else if (query.isAskType()) {
            QueryExecUtils.doAskQuery(prologue, queryExecution, outputFormat, output);
        } else if (query.isJsonType()) {
            QueryExecUtils.doJsonQuery(prologue, queryExecution, outputFormat, output);
        } else {
            throw new QueryException("Unrecognized query form");
        }
        output.flush();
    }

    public static void execute(Op op, DatasetGraph dsg) {
        QueryExecUtils.execute(op, dsg, ResultsFormat.FMT_TEXT);
    }

    public static void execute(Op op, DatasetGraph dsg, ResultsFormat outputFormat) {
        QueryExecUtils.execute(op, dsg, outputFormat, System.out);
    }

    public static void execute(Op op, DatasetGraph dsg, ResultsFormat outputFormat, PrintStream output) {
        QueryIterator qIter = Algebra.exec(op, dsg);
        List<Var> vars = null;
        vars = op instanceof OpProject ? ((OpProject)op).getVars() : new ArrayList<Var>(OpVars.visibleVars(op));
        ResultSet results = ResultSetStream.create(vars, (Iterator<Binding>)((Object)qIter));
        QueryExecUtils.outputResultSet(results, null, outputFormat, output);
        output.flush();
    }

    public static void outputResultSet(ResultSet results, Prologue prologue, ResultsFormat outputFormat, PrintStream output) {
        Lang lang;
        if (outputFormat.equals(ResultsFormat.FMT_UNKNOWN)) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        if (prologue == null) {
            prologue = new Prologue(globalPrefixMap);
        }
        if ((lang = ResultsFormat.convert(outputFormat)) != null) {
            Context context2 = ARQ.getContext().copy();
            if (prologue != null) {
                context2.set(ARQConstants.symPrologue, prologue);
            }
            ResultsWriter.create().context(context2).lang(lang).build().write((OutputStream)output, results);
            output.flush();
            return;
        }
        boolean done = ResultsFormat.oldWrite(output, outputFormat, prologue, results);
        if (!done) {
            System.err.println("Unknown format request: " + outputFormat);
        }
        output.flush();
    }

    private static void doSelectQuery(Prologue prologue, QueryExecution qe, ResultsFormat outputFormat, PrintStream output) {
        if (prologue == null) {
            prologue = qe.getQuery().getPrologue();
        }
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        ResultSet results = qe.execSelect();
        QueryExecUtils.outputResultSet(results, prologue, outputFormat, output);
    }

    private static void doJsonQuery(Prologue prologue, QueryExecution queryExecution, ResultsFormat outputFormat, PrintStream output) {
        JsonArray results = queryExecution.execJson();
        JSON.write(output, (JsonValue)results);
    }

    private static void doDescribeQuery(Prologue prologue, QueryExecution qe, ResultsFormat outputFormat, PrintStream output) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_RDF_TTL;
        }
        Model r = qe.execDescribe();
        QueryExecUtils.writeModel(prologue, r, outputFormat, output);
    }

    private static void doConstructQuery(Prologue prologue, QueryExecution qe, ResultsFormat outputFormat, PrintStream output) {
        if (qe.getQuery().isConstructQuad()) {
            QueryExecUtils.doConstructQuadsQuery(prologue, qe, outputFormat, output);
            return;
        }
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_RDF_TTL;
        }
        Model r = qe.execConstruct();
        QueryExecUtils.writeModel(prologue, r, outputFormat, output);
    }

    private static void doConstructQuadsQuery(Prologue prologue, QueryExecution qe, ResultsFormat outputFormat, PrintStream output) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_RDF_TRIG;
        }
        Dataset ds = qe.execConstructDataset();
        QueryExecUtils.writeDataset(prologue, ds, outputFormat, output);
        output.flush();
    }

    private static void writeModel(Prologue prologue, Model model, ResultsFormat outputFormat, PrintStream output) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        if (outputFormat.equals(ResultsFormat.FMT_NONE)) {
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_TEXT)) {
            output.println("# ======== ");
            RDFDataMgr.write((OutputStream)output, model, Lang.TURTLE);
            output.println("# ======== ");
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_XML)) {
            model.write((OutputStream)output, "RDF/XML-ABBREV", null);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_TTL)) {
            model.write((OutputStream)output, "N3", null);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_N3)) {
            model.write((OutputStream)output, "N3", null);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_NT)) {
            model.write((OutputStream)output, "N-TRIPLES", null);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_NQ)) {
            model.write((OutputStream)output, "N-QUADS", null);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_TRIG)) {
            model.write((OutputStream)output, "TriG", null);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_JSONLD)) {
            RDFDataMgr.write((OutputStream)output, model, Lang.JSONLD);
            return;
        }
        System.err.println("Unknown format: " + outputFormat);
    }

    private static void writeDataset(Prologue prologue, Dataset dataset, ResultsFormat outputFormat, PrintStream output) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        if (outputFormat.equals(ResultsFormat.FMT_NONE)) {
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_TEXT)) {
            output.println("# ======== ");
            RDFDataMgr.write((OutputStream)output, dataset, Lang.TURTLE);
            output.println("# ======== ");
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_NQ)) {
            RDFDataMgr.write((OutputStream)output, dataset, Lang.NQUADS);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_TRIG)) {
            RDFDataMgr.write((OutputStream)output, dataset, Lang.TRIG);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_JSONLD)) {
            RDFDataMgr.write((OutputStream)output, dataset, Lang.JSONLD);
            return;
        }
        System.err.println("Unknown format: " + outputFormat);
    }

    private static void doAskQuery(Prologue prologue, QueryExecution qe, ResultsFormat outputFormat, PrintStream output) {
        boolean b = qe.execAsk();
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        if (outputFormat.equals(ResultsFormat.FMT_NONE)) {
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML((OutputStream)output, b);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_N3) || outputFormat.equals(ResultsFormat.FMT_RDF_TTL)) {
            RDFOutput.outputAsRDF((OutputStream)output, "TURTLE", b);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_JSON)) {
            ResultSetFormatter.outputAsJSON((OutputStream)output, b);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_TEXT)) {
            System.out.println("Ask => " + (b ? "Yes" : "No"));
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_CSV)) {
            ResultSetFormatter.outputAsCSV((OutputStream)System.out, b);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_TSV)) {
            ResultSetFormatter.outputAsTSV((OutputStream)System.out, b);
            return;
        }
        System.err.println("Unknown format: " + outputFormat);
    }

    public static RDFNode getExactlyOne(String qs, Model model) {
        return QueryExecUtils.getExactlyOne(qs, DatasetFactory.wrap(model));
    }

    public static RDFNode getExactlyOne(String qs, Dataset ds) {
        Query q = QueryFactory.create(qs);
        if (q.getResultVars().size() != 1) {
            throw new ARQException("getExactlyOne: Must have exactly one result columns");
        }
        String varname = q.getResultVars().get(0);
        try (QueryExecution qExec = QueryExecutionFactory.create(q, ds);){
            RDFNode rDFNode = QueryExecUtils.getExactlyOne(qExec, varname);
            return rDFNode;
        }
    }

    public static RDFNode getExactlyOne(QueryExecution qExec, String varname) {
        ResultSet rs = qExec.execSelect();
        if (!rs.hasNext()) {
            throw new ARQException("Not found: var ?" + varname);
        }
        QuerySolution qs = rs.nextSolution();
        RDFNode r = qs.get(varname);
        if (rs.hasNext()) {
            throw new ARQException("More than one: var ?" + varname);
        }
        return r;
    }

    public static RDFNode getAtMostOne(QueryExecution qExec, String varname) {
        ResultSet rs = qExec.execSelect();
        if (!rs.hasNext()) {
            return null;
        }
        QuerySolution qs = rs.nextSolution();
        RDFNode r = qs.get(varname);
        if (rs.hasNext()) {
            QuerySolution qs2 = rs.next();
            RDFNode r2 = qs2.get(varname);
            if (rs.hasNext()) {
                throw new ARQException("More than one: var ?" + varname + " -> " + r + ", " + r2 + ", ...");
            }
            throw new ARQException("Found two matches: var ?" + varname + " -> " + r + ", " + r2);
        }
        return r;
    }

    public static List<RDFNode> getAll(QueryExecution qExec, String varname) {
        ResultSet rs = qExec.execSelect();
        ArrayList<RDFNode> matches = new ArrayList<RDFNode>();
        rs.forEachRemaining((Consumer<? super QuerySolution>)((Consumer<QuerySolution>)qs -> {
            RDFNode r = qs.get(varname);
            if (r != null) {
                matches.add(r);
            }
        }));
        return matches;
    }

    static {
        globalPrefixMap.setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        globalPrefixMap.setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        globalPrefixMap.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        globalPrefixMap.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
        globalPrefixMap.setNsPrefix("ex", "http://example.org/");
        globalPrefixMap.setNsPrefix("ns", "http://example.org/ns#");
        globalPrefixMap.setNsPrefix("", "http://example/");
        dftPrologue = new Prologue(globalPrefixMap);
    }
}

