/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.user;

import java.util.HashMap;
import java.util.List;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformSubstitute;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.user.UserDefinedFunctionDefinition;
import org.apache.jena.sparql.sse.builders.SSE_ExprBuildException;
import org.apache.jena.sparql.util.Context;

public class UserDefinedFunction
extends UserDefinedFunctionDefinition
implements Function {
    private Expr actualExpr;

    public UserDefinedFunction(UserDefinedFunctionDefinition def) {
        super(def.getUri(), def.getBaseExpr(), def.getArgList());
    }

    public UserDefinedFunction(String url, Expr e2, List<Var> argList) {
        super(url, e2, argList);
    }

    public void build(String uri, ExprList args) {
        this.build(uri, args, null);
    }

    @Override
    public void build(String uri, ExprList args, Context context2) {
        if (uri == null || !uri.equals(this.getUri())) {
            throw new SSE_ExprBuildException("Incorrect URI passed to build() call, expected <" + this.getUri() + "> but got <" + uri + ">");
        }
        if (this.getArgList().size() != args.size()) {
            throw new SSE_ExprBuildException("Incorrect number of arguments for user defined <" + this.getUri() + "> function");
        }
        HashMap<String, Expr> substitutions = new HashMap<String, Expr>();
        for (int i = 0; i < this.getArgList().size(); ++i) {
            substitutions.put(this.getArgList().get(i).getVarName(), args.get(i));
        }
        this.actualExpr = ExprTransformer.transform((ExprTransform)new ExprTransformSubstitute(substitutions), this.getBaseExpr());
    }

    @Override
    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        return this.actualExpr.eval(binding, env);
    }

    public Expr getActualExpr() {
        return this.actualExpr;
    }
}

