/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.lang;

import java.util.Objects;

public final class CompactUri {
    private final String prefix;
    private final String suffix;
    private final boolean blank;

    private CompactUri(String prefix, String suffix, boolean blank) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.blank = blank;
    }

    public static CompactUri create(String value) {
        int splitIndex = value.indexOf(58, 1);
        if (splitIndex != -1) {
            String prefix = value.substring(0, splitIndex);
            String suffix = value.substring(splitIndex + 1);
            if (!suffix.startsWith("/") && ("_".equals(prefix) || Character.isAlphabetic(prefix.charAt(0)))) {
                return new CompactUri(prefix, suffix, "_".equals(prefix));
            }
        }
        return null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isNotBlank() {
        return !this.blank;
    }

    public String toString() {
        return this.prefix.concat(":").concat(this.suffix);
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.suffix);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompactUri other = (CompactUri)obj;
        return Objects.equals(this.prefix, other.prefix) && Objects.equals(this.suffix, other.suffix);
    }
}

