/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cmd;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.cmd.ArgDecl;

public class Arg {
    private String name = null;
    private String value = null;
    private List<String> values = new ArrayList<String>();

    Arg() {
    }

    Arg(String _name) {
        this();
        this.setName(_name);
    }

    Arg(String _name, String _value) {
        this();
        this.setName(_name);
        this.setValue(_value);
    }

    void setName(String n) {
        this.name = n;
    }

    public void setValue(String v) {
        this.value = v;
    }

    public void addValue(String v) {
        this.values.add(v);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public List<String> getValues() {
        return this.values;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean matches(ArgDecl decl) {
        return decl.getNames().contains(this.name);
    }

    public String toString() {
        String base = (this.name.length() == 1 ? "-" : "--") + this.name;
        if (this.getValues().size() == 0) {
            return base;
        }
        Object str = "";
        String sep = "";
        for (String v : this.getValues()) {
            str = (String)str + sep + base + "=" + v;
            sep = " ";
        }
        return str;
    }
}

