/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.XSDAbstractDateTimeType;
import org.apache.jena.datatypes.xsd.impl.XSDBaseNumericType;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.ExprEvalTypeException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;

public class CastXSD {
    private CastXSD() {
    }

    public static NodeValue cast(NodeValue nv, XSDDatatype castType) {
        Node n = nv.asNode();
        if (n.isBlank()) {
            throw CastXSD.exception("Can't cast blank nodes: " + nv);
        }
        if (n.isURI()) {
            if (castType.equals(XSDDatatype.XSDstring)) {
                return CastXSD.cast$(n.getURI(), castType);
            }
            throw CastXSD.exception("Can't cast URIs to " + castType.getURI());
        }
        if (!n.isLiteral()) {
            throw CastXSD.exception("Can't cast (not a literal, nor URI to string) " + nv + " : " + castType.getURI());
        }
        if (Objects.equals(nv.getNode().getLiteralDatatype(), castType)) {
            String lex = nv.getNode().getLiteralLexicalForm();
            if (castType.isValid(lex)) {
                return nv;
            }
            throw CastXSD.exception("Invalid lexical form for " + castType.getURI());
        }
        if (XSDFuncOp.isNumericDatatype(castType)) {
            return CastXSD.castToNumber(nv, castType);
        }
        if (XSDFuncOp.isDurationDatatype(castType)) {
            return CastXSD.castToDuration(nv, castType);
        }
        if (XSDFuncOp.isTemporalDatatype(castType)) {
            return XSDFuncOp.dateTimeCast(nv, castType);
        }
        if (castType.equals(XSDDatatype.XSDboolean)) {
            return CastXSD.castToBoolean(nv, castType);
        }
        if (castType.equals(XSDDatatype.XSDstring)) {
            return CastXSD.castToString(nv, castType);
        }
        if (XSDFuncOp.isBinaryDatatype(castType)) {
            try {
                Node nValue = nv.getNode();
                byte[] binary = (byte[])nValue.getLiteralValue();
                Node nx = NodeFactory.createLiteralByValue((Object)binary, (RDFDatatype)castType);
                return NodeValue.makeNode(nx);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return CastXSD.castByLex(nv, castType);
    }

    private static NodeValue castToNumber(NodeValue nv, XSDDatatype castType) {
        if (castType.equals(XSDDatatype.XSDdecimal)) {
            if (CastXSD.isDouble(nv) || CastXSD.isFloat(nv)) {
                double d = nv.getDouble();
                if (Double.isNaN(d)) {
                    throw CastXSD.exception("Can't cast NaN to xsd:decimal");
                }
                if (Double.isInfinite(d)) {
                    throw CastXSD.exception("Can't cast Inf or -Inf to xsd:decimal");
                }
                String lex = CastXSD.doubleToDecimalLex(d);
                if (lex == null) {
                    throw CastXSD.exception(nv, castType);
                }
                return NodeValue.makeDecimal(lex);
            }
            if (nv.isBoolean()) {
                boolean b = nv.getBoolean();
                return b ? NodeValue.nvDecimalONE : NodeValue.nvDecimalZERO;
            }
            return CastXSD.castByLex(nv, castType);
        }
        if (XSDFuncOp.isIntegerDatatype(castType)) {
            if (CastXSD.isDouble(nv) || CastXSD.isFloat(nv)) {
                double d = nv.getDouble();
                if (Double.isNaN(d)) {
                    throw CastXSD.exception("Can't cast NaN to xsd:integer");
                }
                if (Double.isInfinite(d)) {
                    throw CastXSD.exception("Can't cast Inf or -Inf to xsd:integer");
                }
                String lex = CastXSD.doubleToIntegerLex(d);
                if (lex != null) {
                    return CastXSD.castByLex(lex, castType);
                }
                throw CastXSD.exception(nv, castType);
            }
            if (CastXSD.isDecimal(nv)) {
                BigDecimal bd = nv.getDecimal();
                String lex = CastXSD.decimalToIntegerLex(bd);
                if (lex != null) {
                    return CastXSD.castByLex(lex, castType);
                }
                throw CastXSD.exception(nv, castType);
            }
            if (nv.isBoolean()) {
                boolean b = nv.getBoolean();
                if (castType.equals(XSDDatatype.XSDinteger)) {
                    return b ? NodeValue.nvONE : NodeValue.nvZERO;
                }
                return CastXSD.cast$(b ? "1" : "0", castType);
            }
            return CastXSD.castByLex(nv, castType);
        }
        if ((castType.equals(XSDDatatype.XSDdouble) || castType.equals(XSDDatatype.XSDfloat)) && nv.isBoolean()) {
            boolean b = nv.getBoolean();
            return CastXSD.cast$(b ? "1.0E0" : "0.0E0", castType);
        }
        return CastXSD.castByLex(nv, castType);
    }

    private static NodeValue castToDuration(NodeValue nv, XSDDatatype castType) {
        if (CastXSD.isDuration(nv)) {
            Duration d = nv.getDuration();
            if (castType.equals(XSDDatatype.XSDyearMonthDuration)) {
                if (nv.isDayTimeDuration()) {
                    return NodeValue.makeNode("P0M", (RDFDatatype)castType);
                }
                Duration d2 = NodeValue.xmlDatatypeFactory.newDuration(d.getSign() >= 0, (BigInteger)d.getField(DatatypeConstants.YEARS), (BigInteger)d.getField(DatatypeConstants.MONTHS), null, null, null, null);
                return NodeValue.makeNode(d2.toString(), (RDFDatatype)castType);
            }
            if (castType.equals(XSDDatatype.XSDdayTimeDuration)) {
                if (nv.isYearMonthDuration()) {
                    return NodeValue.makeNode("PT0S", (RDFDatatype)castType);
                }
                Duration d2 = NodeValue.xmlDatatypeFactory.newDuration(d.getSign() >= 0, null, null, (BigInteger)d.getField(DatatypeConstants.DAYS), (BigInteger)d.getField(DatatypeConstants.HOURS), (BigInteger)d.getField(DatatypeConstants.MINUTES), (BigDecimal)d.getField(DatatypeConstants.SECONDS));
                return NodeValue.makeNode(d2.toString(), (RDFDatatype)castType);
            }
            if (castType.equals(XSDDatatype.XSDduration)) {
                return CastXSD.castByLex(nv, XSDDatatype.XSDduration);
            }
        }
        if (nv.isString()) {
            return CastXSD.castByLex(nv, castType);
        }
        throw CastXSD.exception(nv, castType);
    }

    private static NodeValue castToBoolean(NodeValue nv, XSDDatatype castType) {
        if (nv.isBoolean()) {
            return nv;
        }
        if (nv.isNumber()) {
            if (NodeValue.sameValueAs(nv, NodeValue.nvZERO) || NodeValue.sameValueAs(nv, NodeValue.nvNaN) || NodeValue.sameValueAs(nv, NodeValue.nvNegZERO)) {
                return NodeValue.FALSE;
            }
            return NodeValue.TRUE;
        }
        if (nv.isString()) {
            String str2;
            switch (str2 = nv.getString()) {
                case "0": 
                case "false": {
                    return NodeValue.FALSE;
                }
                case "1": 
                case "true": {
                    return NodeValue.TRUE;
                }
            }
            throw CastXSD.exception(nv, castType);
        }
        return CastXSD.castByLex(nv, castType);
    }

    private static NodeValue castToString(NodeValue nv, XSDDatatype castType) {
        if (CastXSD.isDecimal(nv)) {
            BigDecimal bd = nv.getDecimal();
            String str2 = XSDFuncOp.canonicalDecimalStrNoIntegerDot(bd);
            return NodeValue.makeString(str2);
        }
        if (CastXSD.isBoolean(nv)) {
            boolean b = nv.getBoolean();
            String str3 = b ? "true" : "false";
            return NodeValue.makeString(str3);
        }
        if (CastXSD.isDouble(nv) || CastXSD.isFloat(nv)) {
            double dValue = nv.getDouble();
            if (dValue == 0.0) {
                int cmp = Double.compare(dValue, 0.0);
                if (cmp >= 0) {
                    return NodeValue.makeString("0");
                }
                return NodeValue.makeString("-0");
            }
            if (Double.isNaN(dValue)) {
                return NodeValue.makeString("NaN");
            }
            if (dValue == Double.POSITIVE_INFINITY) {
                return NodeValue.makeString("INF");
            }
            if (dValue == Double.NEGATIVE_INFINITY) {
                return NodeValue.makeString("-INF");
            }
            if (CastXSD.inSmallAboluteRange(dValue)) {
                BigDecimal bd = BigDecimal.valueOf(dValue);
                return NodeValue.makeString(XSDFuncOp.canonicalDecimalStrNoIntegerDot(bd));
            }
            return CastXSD.castByLex(nv, castType);
        }
        return CastXSD.castByLex(nv, castType);
    }

    private static boolean inSmallAboluteRange(double d) {
        return d >= 1.0E-6 && d < 1000000.0 || d <= -1.0E-6 && d > -1000000.0;
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        return bd.signum() == 0 || bd.scale() <= 0 || bd.stripTrailingZeros().scale() <= 0;
    }

    private static boolean isDouble(NodeValue nv) {
        return nv.isDouble() && nv.getDatatypeURI().equals(XSDDatatype.XSDdouble.getURI());
    }

    private static boolean isFloat(NodeValue nv) {
        return nv.isFloat() && nv.getDatatypeURI().equals(XSDDatatype.XSDfloat.getURI());
    }

    private static boolean isDecimal(NodeValue nv) {
        return nv.isDecimal() && nv.getDatatypeURI().equals(XSDDatatype.XSDdecimal.getURI());
    }

    private static boolean isNumeric(NodeValue nv) {
        return nv.isNumber();
    }

    private static boolean isTemporal(NodeValue nv) {
        return nv.hasDateTime();
    }

    private static boolean isDuration(NodeValue nv) {
        return nv.isDuration();
    }

    private static boolean isBoolean(NodeValue nv) {
        return nv.isBoolean();
    }

    private static String xsdName(XSDDatatype datatype) {
        return datatype.getURI().replaceAll("http://www.w3.org/2001/XMLSchema#", "xsd:");
    }

    private static ExprException exception(NodeValue nv, XSDDatatype dt) {
        return CastXSD.exception("Invalid cast: " + nv + " -> " + CastXSD.xsdName(dt));
    }

    private static ExprException exception(String msg) {
        return new ExprEvalTypeException(msg);
    }

    private static NodeValue castByLex(NodeValue nv, XSDDatatype castType) {
        String lex = nv.getNode().getLiteralLexicalForm();
        return CastXSD.castByLex(lex, castType);
    }

    private static NodeValue castByLex(String lex, XSDDatatype castType) {
        if (!castType.isValid(lex)) {
            throw CastXSD.exception("Invalid lexical form: '" + lex + "' for " + castType.getURI());
        }
        if ((castType instanceof XSDBaseNumericType || castType.equals(XSDDatatype.XSDfloat) || castType.equals(XSDDatatype.XSDdouble) || castType.equals(XSDDatatype.XSDboolean) || castType instanceof XSDAbstractDateTimeType) && (lex.startsWith(" ") || lex.endsWith(" "))) {
            throw CastXSD.exception("Not a valid literal form (has whitespace): '" + lex + "'");
        }
        NodeValue nv2 = NodeValue.makeNode(lex, (RDFDatatype)castType);
        RDFDatatype dt = nv2.getNode().getLiteralDatatype();
        if (castType.equals(dt)) {
            return nv2;
        }
        throw CastXSD.exception("Can not cast '" + lex + "' to a " + castType);
    }

    private static NodeValue cast$(String lex, XSDDatatype castType) {
        return NodeValue.makeNode(lex, (RDFDatatype)castType);
    }

    private static String doubleToIntegerLex(double d) {
        long x = Math.round(d);
        if ((double)x == d && x != Long.MAX_VALUE && x != Long.MIN_VALUE) {
            return Long.toString(x);
        }
        String lex = BigDecimal.valueOf(d).toPlainString();
        int i = lex.indexOf(46);
        if (i >= 0) {
            lex = lex.substring(0, i);
        }
        return lex;
    }

    private static String doubleToDecimalLex(double d) {
        String lex = BigDecimal.valueOf(d).toPlainString();
        int i = lex.indexOf(46);
        if (i < 0) {
            return lex + ".0";
        }
        while (i < lex.length() - 2 && lex.endsWith("0")) {
            lex = lex.substring(0, lex.length() - 1);
        }
        return lex;
    }

    private static String decimalToIntegerLex(BigDecimal d) {
        String lex = d.toPlainString();
        int i = lex.indexOf(46);
        if (i >= 0) {
            lex = lex.substring(0, i);
        }
        return lex;
    }
}

