/*
 * Decompiled with CFR 0.152.
 */
package rdfpatch;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.rdfpatch.RDFChanges;
import org.apache.jena.rdfpatch.RDFPatch;
import org.apache.jena.rdfpatch.RDFPatchOps;
import org.apache.jena.rdfpatch.changes.PatchSummary;
import org.apache.jena.rdfpatch.changes.RDFChangesCounter;
import org.apache.jena.rdfpatch.changes.RDFChangesN;
import org.apache.jena.rdfpatch.changes.RDFChangesWriteUpdate;
import org.apache.jena.rdfpatch.text.RDFChangesWriterText;
import org.apache.jena.sys.JenaSystem;
import rdfpatch.CmdRDFPatch;

public class rdfpatch
extends CmdRDFPatch {
    public static void main(String ... args) {
        new rdfpatch(args).mainRun();
    }

    public rdfpatch(String[] argv) {
        super(argv);
    }

    @Override
    protected String getCommandName() {
        return "rdfpatch";
    }

    @Override
    protected void execStart() {
    }

    @Override
    protected void execFinish() {
    }

    @Override
    protected void execOne(String source, InputStream input) {
        RDFPatch patch = RDFPatchOps.read((InputStream)input);
        AWriter out = IO.wrapUTF8((OutputStream)System.out);
        boolean outputAsUpdate = false;
        boolean printStats = !outputAsUpdate;
        RDFChangesWriteUpdate target = outputAsUpdate ? new RDFChangesWriteUpdate(out) : RDFChangesWriterText.create((OutputStream)System.out);
        RDFChangesCounter counter = new RDFChangesCounter();
        RDFChanges dest = RDFChangesN.multi((RDFChanges)target, (RDFChanges)counter);
        dest.start();
        patch.apply(dest);
        dest.finish();
        out.flush();
        if (printStats) {
            PatchSummary summary = counter.summary();
            System.err.printf("# Data:     Adds=%,d Deletes=%,d\n", summary.getCountAddData(), summary.getCountDeleteData());
            System.err.printf("# Prefixes: Adds=%,d Deletes=%,d\n", summary.getCountAddPrefix(), summary.getCountDeletePrefix());
            if (summary.getCountTxnBegin() > 0L || summary.getCountTxnCommit() > 0L || summary.getCountTxnAbort() > 0L) {
                System.err.printf("# Txn:      TX=%,d, TC=%,d, TA=%,d\n", summary.getCountTxnBegin(), summary.getCountTxnCommit(), summary.getCountTxnAbort());
            }
        }
    }

    static {
        LogCtl.setLogging();
        JenaSystem.init();
    }
}

