/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.filelog.rotate;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.Semaphore;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.rdfpatch.filelog.FilePolicy;
import org.apache.jena.rdfpatch.filelog.rotate.ManagedOutput;
import org.apache.jena.rdfpatch.filelog.rotate.OutputStreamManaged;
import org.apache.jena.rdfpatch.filelog.rotate.Roller;
import org.apache.jena.rdfpatch.filelog.rotate.RollerDate;
import org.apache.jena.rdfpatch.filelog.rotate.RollerFixed;
import org.apache.jena.rdfpatch.filelog.rotate.RollerIndex;
import org.apache.jena.rdfpatch.filelog.rotate.RollerShifter;
import org.apache.jena.rdfpatch.filelog.rotate.RollerTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputManagedFile
implements ManagedOutput {
    private static Logger LOG = LoggerFactory.getLogger(OutputManagedFile.class);
    private final Path directory;
    private final String filebase;
    private Path currentFilename = null;
    private final Semaphore sema = new Semaphore(1);
    private FileOutputStream fileOutput = null;
    private OutputStream output = null;
    private OutputStreamManaged currentOutput = null;
    static DateTimeFormatter dateFormatter = DateTimeFormatter.ISO_LOCAL_DATE;
    private final Roller roller;
    private long counter = 0L;

    public OutputManagedFile(Path directory, String baseFilename, FilePolicy strategy) {
        this.directory = directory;
        this.filebase = baseFilename;
        this.roller = OutputManagedFile.roller(directory, baseFilename, strategy);
    }

    private static Roller roller(Path directory, String baseFilename, FilePolicy strategy) {
        switch (strategy) {
            case DATE: {
                return new RollerDate(directory, baseFilename);
            }
            case INDEX: {
                return new RollerIndex(directory, baseFilename, "%04d");
            }
            case SHIFT: {
                return new RollerShifter(directory, baseFilename, "%03d");
            }
            case TIMESTAMP: {
                return new RollerTimestamp(directory, baseFilename);
            }
            case FIXED: {
                return new RollerFixed(directory, baseFilename);
            }
        }
        return null;
    }

    @Override
    public Roller roller() {
        return this.roller;
    }

    @Override
    public OutputStream currentOutput() {
        return this.currentOutput;
    }

    @Override
    public Path currentFilename() {
        return this.currentOutput != null ? this.currentFilename : null;
    }

    @Override
    public Path latestFilename() {
        return this.roller.latestFilename();
    }

    @Override
    public OutputStream output() {
        try {
            this.sema.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        this.roller.startSection();
        this.advanceIfNecessary();
        this.currentOutput = new OutputStreamManaged(this.output, x -> this.finish());
        return this.currentOutput;
    }

    @Override
    public void rotate() {
        this.finish();
        this.roller.rotate();
    }

    private void finish() {
        this.roller.finishSection();
        try {
            this.currentOutput = null;
            if (this.output != null) {
                this.output.flush();
                this.fileOutput.getFD().sync();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.sema.availablePermits() == 0) {
            this.sema.release();
        }
    }

    private boolean hasActiveFile() {
        return this.output != null;
    }

    private void advanceIfNecessary() {
        if (this.roller.hasExpired()) {
            this.closeOutput();
        }
        if (!this.hasActiveFile()) {
            this.nextFile();
        }
    }

    private void flushOutput() {
        try {
            this.output.flush();
            this.fileOutput.getFD().sync();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void closeOutput() {
        if (this.output == null) {
            return;
        }
        this.flushOutput();
        IO.close((Closeable)this.output);
        this.output = null;
        this.fileOutput = null;
        this.currentOutput = null;
    }

    private void nextFile() {
        try {
            this.currentFilename = this.roller.nextFilename();
            FmtLog.debug((Logger)LOG, (String)"Setup: %s", (Object[])new Object[]{this.currentFilename});
            this.fileOutput = new FileOutputStream(this.currentFilename.toString(), true);
            this.output = new BufferedOutputStream(this.fileOutput);
        }
        catch (FileNotFoundException ex) {
            IO.exception((IOException)ex);
            return;
        }
    }
}

