/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.solver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterAbortable;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.main.solver.SolverLib;
import org.apache.jena.tdb2.lib.NodeLib;
import org.apache.jena.tdb2.solver.BindingNodeId;
import org.apache.jena.tdb2.solver.BindingTDB;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;
import org.apache.jena.tdb2.store.tupletable.TupleTable;
import org.apache.jena.tdb2.sys.TDBInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolverLibTDB {
    private static Logger log = LoggerFactory.getLogger(SolverLibTDB.class);
    private static Tuple<NodeId> TupleANY = TupleFactory.create4((Object)NodeId.NodeIdAny, (Object)NodeId.NodeIdAny, (Object)NodeId.NodeIdAny, (Object)NodeId.NodeIdAny);
    private static Function<Tuple<NodeId>, Tuple<NodeId>> quadsToAnyTriples = item -> TupleFactory.create4((Object)NodeId.NodeIdAny, (Object)((NodeId)item.get(1)), (Object)((NodeId)item.get(2)), (Object)((NodeId)item.get(3)));

    static Iterator<BindingNodeId> convertToIds(Iterator<Binding> iterBindings, NodeTable nodeTable) {
        return Iter.map(iterBindings, SolverLibTDB.convFromBinding(nodeTable));
    }

    static Iterator<Binding> convertToNodes(Iterator<BindingNodeId> iterBindingIds, NodeTable nodeTable) {
        return Iter.map(iterBindingIds, bindingNodeIds -> SolverLibTDB.convToBinding(bindingNodeIds, nodeTable));
    }

    static Binding convToBinding(BindingNodeId bindingNodeIds, NodeTable nodeTable) {
        return new BindingTDB(bindingNodeIds, nodeTable);
    }

    static Iterator<BindingNodeId> convFromBinding(Iterator<Binding> input, NodeTable nodeTable) {
        return Iter.map(input, SolverLibTDB.convFromBinding(nodeTable));
    }

    static Function<Binding, BindingNodeId> convFromBinding(NodeTable nodeTable) {
        return binding -> SolverLibTDB.convert(binding, nodeTable);
    }

    static BindingNodeId convert(Binding binding, NodeTable nodeTable) {
        if (binding instanceof BindingTDB) {
            return ((BindingTDB)binding).getBindingId();
        }
        BindingNodeId b = new BindingNodeId(binding);
        Iterator vars = binding.vars();
        while (vars.hasNext()) {
            Var v = (Var)vars.next();
            Node n = binding.get(v);
            if (n == null) continue;
            NodeId id = nodeTable.getNodeIdForNode(n);
            b.put(v, id);
        }
        return b;
    }

    static QueryIterator testForGraphName(DatasetGraphTDB ds, Node graphNode, QueryIterator input, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        boolean exists;
        NodeId nid = TDBInternal.getNodeId(ds, graphNode);
        boolean bl = exists = !NodeId.isDoesNotExist(nid);
        if (exists) {
            NodeTupleTable ntt = ds.getQuadTable().getNodeTupleTable();
            Iterator iter1 = ntt.find(nid, NodeId.NodeIdAny, NodeId.NodeIdAny, NodeId.NodeIdAny);
            if (filter != null) {
                iter1 = Iter.filter(iter1, filter);
            }
            exists = iter1.hasNext();
        }
        if (exists) {
            return input;
        }
        input.close();
        return QueryIterNullIterator.create((ExecutionContext)execCxt);
    }

    static QueryIterator graphNames(DatasetGraphTDB ds, Node graphNode, QueryIterator input, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        boolean needDistinct;
        Iterator iter1;
        ArrayList killList = new ArrayList();
        NodeTupleTable ntt = ds.getQuadTable().getNodeTupleTable();
        TupleIndex idx = SolverLibTDB.findGraphIndex(ntt.getTupleTable(), "G");
        if (idx == null) {
            iter1 = ntt.findAll();
            needDistinct = true;
        } else {
            iter1 = idx.find(TupleANY);
            needDistinct = false;
        }
        if (filter != null) {
            iter1 = Iter.filter(iter1, filter);
        }
        Iterator iter2 = Iter.map(iter1, t -> (NodeId)t.get(0));
        iter2 = SolverLib.makeAbortable((Iterator)iter2, killList);
        Iterator iter3 = needDistinct ? Iter.distinct((Iterator)iter2) : Iter.distinctAdjacent((Iterator)iter2);
        iter3 = SolverLib.makeAbortable((Iterator)iter3, killList);
        Iterator<Node> iter4 = NodeLib.nodes(ds.getQuadTable().getNodeTupleTable().getNodeTable(), iter3);
        Var var = Var.alloc((Node)graphNode);
        Iterator iterBinding = Iter.map(iter4, node -> BindingFactory.binding((Var)var, (Node)node));
        return new QueryIterAbortable(iterBinding, killList, input, execCxt);
    }

    private static TupleIndex findGraphIndex(TupleTable tupleTable, String indexPrefix) {
        TupleIndex[] indexes = tupleTable.getIndexes();
        for (int i = 0; i < indexes.length; ++i) {
            TupleIndex idx = indexes[i];
            String n = idx.getName();
            if (!n.startsWith(indexPrefix)) continue;
            return idx;
        }
        return null;
    }

    static Set<NodeId> convertToNodeIds(Collection<Node> nodes, DatasetGraphTDB dataset) {
        HashSet<NodeId> graphIds = new HashSet<NodeId>();
        NodeTable nt = dataset.getQuadTable().getNodeTupleTable().getNodeTable();
        for (Node n : nodes) {
            graphIds.add(nt.getNodeIdForNode(n));
        }
        return graphIds;
    }

    public static Iterator<Tuple<NodeId>> unionGraph(NodeTupleTable ntt) {
        Iterator iter = ntt.find(new NodeId[]{null, null, null, null});
        iter = Iter.map(iter, quadsToAnyTriples);
        iter = Iter.distinctAdjacent((Iterator)iter);
        return iter;
    }
}

