/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmlinput.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.iri.IRI;
import org.apache.jena.rdfxml.xmlinput.ARPErrorNumbers;
import org.apache.jena.rdfxml.xmlinput.impl.ANode;
import org.apache.jena.rdfxml.xmlinput.impl.ARPLocation;
import org.apache.jena.rdfxml.xmlinput.impl.AbsXMLContext;
import org.apache.jena.rdfxml.xmlinput.impl.CharacterModel;
import org.apache.jena.rdfxml.xmlinput.impl.Names;
import org.apache.jena.rdfxml.xmlinput.impl.Taint;
import org.apache.jena.rdfxml.xmlinput.impl.XMLHandler;
import org.apache.jena.util.XML11Char;
import org.apache.jena.util.XMLChar;
import org.xml.sax.SAXParseException;

public class ParserSupport
implements ARPErrorNumbers,
Names {
    protected final XMLHandler arp;
    public final AbsXMLContext xml;

    protected ParserSupport(XMLHandler arp, AbsXMLContext xml) {
        this.arp = arp;
        this.xml = xml;
    }

    Map<IRI, Map<String, ARPLocation>> idsUsed() {
        return this.arp.idsUsed;
    }

    protected void checkIdSymbol(Taint taintMe, AbsXMLContext ctxt, String str) throws SAXParseException {
        if (this.arp.idsUsed != null) {
            ARPLocation prev;
            IRI uri = ctxt.uri;
            Map<String, ARPLocation> idsUsedForBase = this.idsUsed().get(uri);
            if (idsUsedForBase == null) {
                idsUsedForBase = new HashMap<String, ARPLocation>();
                this.idsUsed().put(uri, idsUsedForBase);
            }
            if ((prev = idsUsedForBase.get(str)) != null) {
                this.arp.warning(taintMe, 105, "Redefinition of ID: " + str);
                this.arp.warning(taintMe, 105, prev, "Previous definition of '" + str + "'.");
            } else {
                idsUsedForBase.put(str, this.arp.location());
                ++this.arp.idsUsedCount;
                if (this.arp.idsUsedCount > 10000) {
                    this.arp.idsUsed = null;
                    this.arp.warning(taintMe, 137, "Input is large. Switching off checking for illegal reuse of rdf:ID's.");
                }
            }
        }
        this.checkID_XMLName(taintMe, str);
        this.checkEncoding(taintMe, str);
    }

    protected void checkNodeID_XMLName(Taint taintMe, String str) throws SAXParseException {
        if (!XMLChar.isValidNCName(str)) {
            this.warning(taintMe, 108, "Not an XML Name: '" + str + "'");
        }
    }

    protected void checkID_XMLName(Taint taintMe, String str) throws SAXParseException {
        if (!XML11Char.isXML11ValidNCName(str)) {
            this.warning(taintMe, 108, "Not an XML Name: '" + str + "'");
        }
    }

    public void checkString(Taint taintMe, String t) throws SAXParseException {
        if (!CharacterModel.isNormalFormC(t)) {
            this.warning(taintMe, 131, "String not in Unicode Normal Form C: \"" + t + "\"");
        }
        this.checkEncoding(taintMe, t);
        this.checkComposingChar(taintMe, t);
    }

    void checkComposingChar(Taint taintMe, String t) throws SAXParseException {
        if (CharacterModel.startsWithComposingCharacter(t)) {
            this.warning(taintMe, 121, "String is not legal in XML 1.1; starts with composing char: \"" + t + "\" (" + t.charAt(0) + ")");
        }
    }

    public void checkComposingChar(Taint taintMe, char[] ch, int st, int ln) throws SAXParseException {
        if (ln > 0 && CharacterModel.isComposingChar(ch[st])) {
            this.warning(taintMe, 121, "String is not legal in XML 1.1; starts with composing char: \"" + new String(ch, st, ln) + "\" (" + ch[st] + ")");
        }
    }

    public void checkEncoding(Taint taintMe, String s) throws SAXParseException {
        if (this.arp.encodingProblems) {
            for (int i = s.length() - 1; i >= 0; --i) {
                if (s.charAt(i) >= '\u0000' && s.charAt(i) <= '\u007f') continue;
                this.warning(taintMe, 210, "Encoding error with non-ascii characters.");
                break;
            }
        }
    }

    protected void warning(Taint taintMe, int i, String msg) throws SAXParseException {
        this.arp.warning(taintMe, i, msg);
    }

    protected boolean isWhite(char[] ch, int st, int ln) {
        for (int i = 0; i < ln; ++i) {
            if (this.isWhite(ch[st + i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isWhite(StringBuffer buf) {
        for (int i = buf.length() - 1; i >= 0; --i) {
            if (this.isWhite(buf.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isWhite(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    protected void triple(ANode a, ANode b, ANode c) {
        this.arp.triple(a, b, c);
    }

    public AbsXMLContext getXMLContext() {
        return this.xml;
    }

    public XMLHandler getXMLHandler() {
        return this.arp;
    }

    protected String resolve(Taint taintMe, AbsXMLContext x, String uri) throws SAXParseException {
        IRI ref = x.resolveAsURI(this.arp, taintMe, uri);
        return ref.toString();
    }
}

