/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.NoSuchElementException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter1;

public abstract class QueryIterRepeatApply
extends QueryIter1 {
    private int count = 0;
    private QueryIterator currentStage = null;
    private volatile boolean cancelRequested = false;

    public QueryIterRepeatApply(QueryIterator input, ExecutionContext context2) {
        super(input, context2);
        if (input == null) {
            Log.error((Object)this, (String)"[QueryIterRepeatApply] Repeated application to null input iterator");
            return;
        }
    }

    protected QueryIterator getCurrentStage() {
        return this.currentStage;
    }

    protected abstract QueryIterator nextStage(Binding var1);

    @Override
    protected boolean hasNextBinding() {
        if (this.isFinished()) {
            return false;
        }
        while (true) {
            if (this.currentStage == null) {
                this.currentStage = this.makeNextStage();
            }
            if (this.currentStage == null) {
                return false;
            }
            if (this.cancelRequested) {
                QueryIterRepeatApply.performRequestCancel(this.currentStage);
            }
            if (this.currentStage.hasNext()) {
                return true;
            }
            this.currentStage.close();
            this.currentStage = null;
        }
    }

    @Override
    protected Binding moveToNextBinding() {
        if (!this.hasNextBinding()) {
            throw new NoSuchElementException(Lib.className((Object)this) + ".next()/finished");
        }
        return this.currentStage.nextBinding();
    }

    private QueryIterator makeNextStage() {
        ++this.count;
        if (this.getInput() == null) {
            return null;
        }
        if (!this.getInput().hasNext()) {
            this.getInput().close();
            return null;
        }
        Binding binding = (Binding)this.getInput().next();
        QueryIterator iter = this.nextStage(binding);
        return iter;
    }

    @Override
    protected void closeSubIterator() {
        if (this.currentStage != null) {
            this.currentStage.close();
        }
    }

    @Override
    protected void requestSubCancel() {
        if (this.currentStage != null) {
            this.currentStage.cancel();
        }
        this.cancelRequested = true;
    }
}

