/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.datatypes;

import java.util.Objects;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.impl.LiteralLabel;

public class BaseDatatype
implements RDFDatatype {
    protected String uri;

    public BaseDatatype(String uri) {
        this.uri = uri;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String unparse(Object value) {
        if (value instanceof TypedValue) {
            return ((TypedValue)value).lexicalValue;
        }
        return value.toString();
    }

    @Override
    public Object parse(String lexicalForm) throws DatatypeFormatException {
        return new TypedValue(lexicalForm, this.getURI());
    }

    @Override
    public boolean isValid(String lexicalForm) {
        try {
            this.parse(lexicalForm);
            return true;
        }
        catch (DatatypeFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isValidLiteral(LiteralLabel lit) {
        return this.equals(lit.getDatatype());
    }

    @Override
    public boolean isValidValue(Object valueForm) {
        return this.isValid(this.unparse(valueForm));
    }

    @Override
    public boolean isEqual(LiteralLabel litLabel1, LiteralLabel litLabel2) {
        return BaseDatatype.isEqualPlain(litLabel1, litLabel2);
    }

    protected static boolean isEqualPlain(LiteralLabel litLabel1, LiteralLabel litLabel2) {
        return litLabel1.getDatatype() == litLabel2.getDatatype() && litLabel1.getValue().equals(litLabel2.getValue());
    }

    protected static boolean isEqualByTerm(LiteralLabel value1, LiteralLabel value2) {
        if (value2 == null && value1 == null) {
            return true;
        }
        if (value2 == null) {
            return false;
        }
        if (value1 == null) {
            return false;
        }
        return Objects.equals(value1.getLexicalForm(), value2.getLexicalForm()) && Objects.equals(value1.getDatatype(), value2.getDatatype()) && Objects.equals(value1.language(), value2.language());
    }

    @Override
    public int getHashCode(LiteralLabel lit) {
        return lit.getDefaultHashcode();
    }

    public boolean langTagCompatible(LiteralLabel value1, LiteralLabel value2) {
        if (value1.language() == null) {
            return value2.language() == null || value2.language().equals("");
        }
        return value1.language().equalsIgnoreCase(value2.language());
    }

    @Override
    public Class<?> getJavaClass() {
        return null;
    }

    @Override
    public Object cannonicalise(Object value) {
        return value;
    }

    @Override
    public Object extendedTypeDefinition() {
        return null;
    }

    @Override
    public RDFDatatype normalizeSubType(Object value, RDFDatatype dt) {
        return this;
    }

    public String toString() {
        return "Datatype[" + this.uri + (String)(this.getJavaClass() == null ? "" : " -> " + this.getJavaClass()) + "]";
    }

    public static class TypedValue {
        public final String lexicalValue;
        public final String datatypeURI;

        public TypedValue(String lexicalValue, String datatypeURI) {
            this.lexicalValue = lexicalValue;
            this.datatypeURI = datatypeURI;
        }

        public boolean equals(Object other) {
            if (other instanceof TypedValue) {
                return this.lexicalValue.equals(((TypedValue)other).lexicalValue) && this.datatypeURI.equals(((TypedValue)other).datatypeURI);
            }
            return false;
        }

        public int hashCode() {
            return this.lexicalValue.hashCode() ^ this.datatypeURI.hashCode();
        }
    }
}

