/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.nodevalue;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueVisitor;
import org.apache.jena.sparql.util.FmtUtils;

public class NodeValueString
extends NodeValue {
    private String string;

    public NodeValueString(String str2) {
        this.string = str2;
    }

    public NodeValueString(String str2, Node n) {
        super(n);
        this.string = str2;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return this.string;
    }

    @Override
    public String asString() {
        return this.string;
    }

    @Override
    public String toString() {
        if (this.getNode() != null) {
            return FmtUtils.stringForNode(this.getNode());
        }
        return "\"" + this.string + "\"";
    }

    @Override
    protected Node makeNode() {
        return NodeFactory.createLiteral((String)this.string);
    }

    @Override
    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

