/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorExpr;
import org.apache.jena.sparql.expr.aggregate.AggGroupConcat;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.serializer.SerializationContext;

public class AggGroupConcatDistinct
extends AggregatorBase {
    private final String separator;
    private final String effectiveSeparator;

    public AggGroupConcatDistinct(Expr expr, String separator) {
        this(expr, separator != null ? separator : " ", separator);
    }

    private AggGroupConcatDistinct(Expr expr, String effectiveSeparator, String separatorSeen) {
        super("GROUP_CONCAT", true, expr);
        this.separator = separatorSeen;
        this.effectiveSeparator = effectiveSeparator;
    }

    @Override
    public Aggregator copy(ExprList exprs) {
        return new AggGroupConcatDistinct(exprs.get(0), this.effectiveSeparator, this.separator);
    }

    @Override
    public String toPrefixString() {
        return AggGroupConcat.prefixGroupConcatString(this.isDistinct, this.separator, this.getExprList());
    }

    @Override
    public String asSparqlExpr(SerializationContext sCxt) {
        return AggGroupConcat.asSparqlExpr(this.isDistinct, this.separator, this.exprList, sCxt);
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccGroupConcatDistinct(this.getExpr(), this.effectiveSeparator);
    }

    public String getSeparator() {
        return this.separator;
    }

    @Override
    public Node getValueEmpty() {
        return null;
    }

    @Override
    public int hashCode() {
        return 0x174 ^ this.getExpr().hashCode();
    }

    @Override
    public boolean equals(Aggregator other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggGroupConcatDistinct)) {
            return false;
        }
        AggGroupConcatDistinct agg = (AggGroupConcatDistinct)other;
        return Objects.equals(agg.getSeparator(), this.getSeparator()) && agg.getExpr().equals(this.getExpr(), bySyntax);
    }

    static class AccGroupConcatDistinct
    extends AccumulatorExpr {
        private StringBuilder stringSoFar = new StringBuilder();
        private boolean first = true;
        private final String separator;

        public AccGroupConcatDistinct(Expr expr, String sep) {
            super(expr, true);
            this.separator = sep;
        }

        @Override
        public void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            String str2 = nv.asString();
            if (!this.first) {
                this.stringSoFar.append(this.separator);
            }
            this.stringSoFar.append(str2);
            this.first = false;
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getAccValue() {
            return NodeValue.makeString(this.stringSoFar.toString());
        }
    }
}

