/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.PropertyFunctionGenerator;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sparql.util.Context;

public class TransformPropertyFunction
extends TransformCopy {
    private final Context context;
    private final boolean doingPropertyFunctions;
    private final PropertyFunctionRegistry registry;

    public static Op transform(Op op, Context context2) {
        TransformPropertyFunction t = new TransformPropertyFunction(context2);
        return Transformer.transform(t, op);
    }

    public TransformPropertyFunction(Context context2) {
        this.context = context2;
        this.registry = PropertyFunctionRegistry.chooseRegistry(context2);
        this.doingPropertyFunctions = this.registry != null && context2.isTrueOrUndef(ARQ.enablePropertyFunctions);
    }

    @Override
    public Op transform(OpTriple opTriple) {
        if (!this.doingPropertyFunctions) {
            return opTriple;
        }
        Op x = this.transform(opTriple.asBGP());
        if (!(x instanceof OpBGP)) {
            return x;
        }
        if (opTriple.equivalent((OpBGP)x)) {
            return opTriple;
        }
        return x;
    }

    @Override
    public Op transform(OpBGP opBGP) {
        if (!this.doingPropertyFunctions) {
            return opBGP;
        }
        return PropertyFunctionGenerator.buildPropertyFunctions(this.registry, opBGP, this.context);
    }
}

