/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.irix;

public class Chars3986 {
    public static final char EOF = '\uffff';

    public static boolean isPChar(char ch, String str, int posn) {
        return Chars3986.unreserved(ch) || Chars3986.isPctEncoded(ch, str, posn) || Chars3986.subDelims(ch) || ch == ':' || ch == '@';
    }

    public static boolean isIPChar(char ch, String str, int posn) {
        return Chars3986.isPChar(ch, str, posn) || Chars3986.isUcsChar(ch);
    }

    public static boolean isPctEncoded(char ch, CharSequence s, int x) {
        if (ch != '%') {
            return false;
        }
        char ch1 = Chars3986.charAt(s, x + 1);
        char ch2 = Chars3986.charAt(s, x + 2);
        return Chars3986.percentCheck(x, ch1, ch2);
    }

    public static boolean isAlpha(char ch) {
        return Chars3986.range(ch, 97, 122) || Chars3986.range(ch, 65, 90);
    }

    public static boolean isIAlpha(char ch) {
        return Chars3986.isAlpha(ch) || Chars3986.isUcsChar(ch);
    }

    public static boolean isUcsChar(char ch) {
        return Chars3986.range(ch, 160, 55295) || Chars3986.range(ch, 63744, 64975) || Chars3986.range(ch, 65008, 65519) || Character.isSurrogate(ch);
    }

    public static boolean int_isUcsChar(int ch) {
        boolean b;
        boolean bl = b = Chars3986.range(ch, 160, 55295) || Chars3986.range(ch, 63744, 64975) || Chars3986.range(ch, 65008, 65519);
        if (b) {
            return true;
        }
        if (ch < 65536) {
            return false;
        }
        return Chars3986.range(ch, 65536, 131069) || Chars3986.range(ch, 131072, 196605) || Chars3986.range(ch, 196608, 262141) || Chars3986.range(ch, 262144, 327677) || Chars3986.range(ch, 327680, 393213) || Chars3986.range(ch, 393216, 458749) || Chars3986.range(ch, 458752, 524285) || Chars3986.range(ch, 524288, 589821) || Chars3986.range(ch, 589824, 655357) || Chars3986.range(ch, 655360, 720893) || Chars3986.range(ch, 720896, 786429) || Chars3986.range(ch, 786432, 851965) || Chars3986.range(ch, 851968, 917501) || Chars3986.range(ch, 921600, 983037);
    }

    public static boolean isIPrivate(char ch) {
        return Chars3986.range(ch, 57344, 63743);
    }

    public static boolean int_isIPrivate(int ch) {
        return Chars3986.range(ch, 57344, 63743) || Chars3986.range(ch, 983040, 1048573) || Chars3986.range(ch, 0x100000, 1114109);
    }

    public static boolean unreserved(char ch) {
        if (Chars3986.isAlpha(ch) || Chars3986.isDigit(ch)) {
            return true;
        }
        switch (ch) {
            case '-': 
            case '.': 
            case '_': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public static boolean iunreserved(char ch) {
        if (Chars3986.isIAlpha(ch) || Chars3986.isDigit(ch)) {
            return true;
        }
        switch (ch) {
            case '-': 
            case '.': 
            case '_': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public static boolean subDelims(char ch) {
        switch (ch) {
            case '!': 
            case '$': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case ';': 
            case '=': {
                return true;
            }
        }
        return false;
    }

    public static boolean genDelims(char ch) {
        switch (ch) {
            case '#': 
            case '/': 
            case ':': 
            case '?': 
            case '@': 
            case '[': 
            case ']': {
                return true;
            }
        }
        return false;
    }

    public static String displayChar(char ch) {
        return String.format("%c (0x%04X)", Character.valueOf(ch), (int)ch);
    }

    private static boolean percentCheck(int idx, char ch1, char ch2) {
        if (ch1 == '\uffff' || ch2 == '\uffff') {
            Chars3986.parseError(idx + 1, "Incomplete %-encoded character");
            return false;
        }
        if (Chars3986.isHexDigit(ch1) && Chars3986.isHexDigit(ch2)) {
            return true;
        }
        Chars3986.parseError(idx + 1, "Bad %-encoded character [" + Chars3986.displayChar(ch1) + " " + Chars3986.displayChar(ch2) + "]");
        return false;
    }

    public static char charAt(CharSequence str, int x) {
        if (x >= str.length()) {
            return '\uffff';
        }
        return str.charAt(x);
    }

    public static boolean range(int ch, int start, int finish) {
        return ch >= start && ch <= finish;
    }

    public static boolean isDigit(char ch) {
        return Chars3986.range(ch, 48, 57);
    }

    public static boolean isHexDigit(char ch) {
        return Chars3986.range(ch, 48, 57) || Chars3986.range(ch, 65, 70) || Chars3986.range(ch, 97, 102);
    }

    public static int hexValue(char ch) {
        if (Chars3986.range(ch, 48, 57)) {
            return ch - 48;
        }
        if (Chars3986.range(ch, 65, 70)) {
            return ch - 65 + 10;
        }
        if (Chars3986.range(ch, 97, 102)) {
            return ch - 97 + 10;
        }
        return -1;
    }

    private static void parseError(int posn, String s) {
    }
}

