/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.expansion;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.StringUtils;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.expansion.ObjectExpansion1314;
import com.apicatalog.jsonld.json.JsonMapBuilder;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.NodeObject;
import com.apicatalog.jsonld.lang.Utils;
import com.apicatalog.jsonld.uri.UriUtils;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ObjectExpansion {
    private ActiveContext activeContext;
    private JsonValue propertyContext;
    private JsonObject element;
    private String activeProperty;
    private URI baseUrl;
    private boolean frameExpansion;
    private boolean ordered;
    private boolean fromMap;

    private ObjectExpansion(ActiveContext activeContext, JsonValue propertyContext, JsonObject element, String activeProperty, URI baseUrl) {
        this.activeContext = activeContext;
        this.propertyContext = propertyContext;
        this.element = element;
        this.activeProperty = activeProperty;
        this.baseUrl = baseUrl;
        this.frameExpansion = false;
        this.ordered = false;
        this.fromMap = false;
    }

    public static final ObjectExpansion with(ActiveContext activeContext, JsonValue propertyContext, JsonObject element, String activeProperty, URI baseUrl) {
        return new ObjectExpansion(activeContext, propertyContext, element, activeProperty, baseUrl);
    }

    public ObjectExpansion frameExpansion(boolean value) {
        this.frameExpansion = value;
        return this;
    }

    public ObjectExpansion ordered(boolean value) {
        this.ordered = value;
        return this;
    }

    public ObjectExpansion fromMap(boolean value) {
        this.fromMap = value;
        return this;
    }

    public JsonValue expand() throws JsonLdError {
        this.initPreviousContext();
        this.initPropertyContext();
        this.initLocalContext();
        ActiveContext typeContext = this.activeContext;
        String typeKey = this.processTypeScoped(typeContext);
        String inputType = this.findInputType(typeKey);
        JsonMapBuilder result = JsonMapBuilder.create();
        ObjectExpansion1314.with(this.activeContext, this.element, this.activeProperty, this.baseUrl).inputType(inputType).result(result).typeContext(typeContext).nest(new LinkedHashMap<String, JsonValue>()).frameExpansion(this.frameExpansion).ordered(this.ordered).expand();
        if (result.containsKey("@value")) {
            return this.normalizeValue(result);
        }
        if (result.containsKey("@type")) {
            return this.normalizeType(result);
        }
        if (result.containsKey("@list") || result.containsKey("@set")) {
            return this.normalizeContainer(result);
        }
        return this.normalize(result);
    }

    private void initPropertyContext() throws JsonLdError {
        if (this.propertyContext != null) {
            this.activeContext = this.activeContext.newContext().overrideProtected(true).create(this.propertyContext, this.activeContext.getTerm(this.activeProperty).map(TermDefinition::getBaseUrl).orElse(null));
        }
    }

    private void initPreviousContext() throws JsonLdError {
        if (this.activeContext.getPreviousContext() != null && !this.fromMap) {
            boolean revert = true;
            for (String key : Utils.index(this.element.keySet(), true)) {
                String expandedKey = this.activeContext.uriExpansion().vocab(true).expand(key);
                if (!"@value".equals(expandedKey) && (!"@id".equals(expandedKey) || this.element.size() != 1)) continue;
                revert = false;
                break;
            }
            if (revert) {
                this.activeContext = this.activeContext.getPreviousContext();
            }
        }
    }

    private void initLocalContext() throws JsonLdError {
        if (this.element.containsKey((Object)"@context")) {
            this.activeContext = this.activeContext.newContext().create((JsonValue)this.element.get((Object)"@context"), this.baseUrl);
        }
    }

    private String processTypeScoped(ActiveContext typeContext) throws JsonLdError {
        String typeKey = null;
        for (String key : Utils.index(this.element.keySet(), true)) {
            String expandedKey = this.activeContext.uriExpansion().vocab(true).expand(key);
            if (!"@type".equals(expandedKey)) continue;
            if (typeKey == null) {
                typeKey = key;
            }
            List terms = JsonUtils.toStream((JsonValue)this.element.get((Object)key)).filter(JsonUtils::isString).map(JsonString.class::cast).map(JsonString::getString).sorted().collect(Collectors.toList());
            for (String term : terms) {
                Optional<JsonValue> localContext = typeContext.getTerm(term).map(TermDefinition::getLocalContext);
                if (!localContext.isPresent()) continue;
                Optional<TermDefinition> valueDefinition = this.activeContext.getTerm(term);
                this.activeContext = this.activeContext.newContext().propagate(false).create(localContext.get(), valueDefinition.map(TermDefinition::getBaseUrl).orElse(null));
            }
        }
        return typeKey;
    }

    private String findInputType(String typeKey) throws JsonLdError {
        if (typeKey != null) {
            JsonValue type = (JsonValue)this.element.get((Object)typeKey);
            if (JsonUtils.isArray(type)) {
                String lastValue = type.asJsonArray().stream().filter(JsonUtils::isString).map(JsonString.class::cast).map(JsonString::getString).sorted().reduce((first, second) -> second).orElse(null);
                if (lastValue != null) {
                    return this.activeContext.uriExpansion().vocab(true).expand(lastValue);
                }
            } else if (JsonUtils.isString(type)) {
                return this.activeContext.uriExpansion().vocab(true).expand(((JsonString)type).getString());
            }
        }
        return null;
    }

    private JsonValue normalizeValue(JsonMapBuilder result) throws JsonLdError {
        if (result.isNotValueObject()) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_VALUE_OBJECT);
        }
        if ((result.containsKey("@direction") || result.containsKey("@language")) && result.containsKey("@type")) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_VALUE_OBJECT);
        }
        Optional<JsonValue> type = result.get("@type");
        if (type.map(t -> !JsonUtils.contains("@json", t)).orElse(true).booleanValue()) {
            Optional<JsonValue> value = result.get("@value");
            if (value.map(v -> JsonUtils.isNull(v) || JsonUtils.isArray(v) && v.asJsonArray().isEmpty()).orElse(true).booleanValue()) {
                return JsonValue.NULL;
            }
            if (!this.frameExpansion && JsonUtils.isNotString(value.get()) && result.containsKey("@language")) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_LANGUAGE_TAGGED_VALUE);
            }
            if (!this.frameExpansion && type.filter(t -> JsonUtils.isNotString(t) || UriUtils.isNotURI(((JsonString)t).getString())).isPresent()) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_TYPED_VALUE);
            }
        }
        return this.normalize(result);
    }

    private JsonValue normalizeType(JsonMapBuilder result) throws JsonLdError {
        result.get("@type").filter(JsonUtils::isNotArray).filter(JsonUtils::isNotNull).ifPresent(value -> result.put("@type", (JsonValue)Json.createArrayBuilder().add(value).build()));
        return this.normalize(result);
    }

    private JsonValue normalizeContainer(JsonMapBuilder result) throws JsonLdError {
        if (result.size() > 2 || result.size() == 2 && !result.containsKey("@index")) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_SET_OR_LIST_OBJECT);
        }
        Optional<JsonValue> set = result.get("@set");
        if (set.filter(JsonUtils::isObject).isPresent()) {
            return this.normalize(JsonMapBuilder.create(set.map(JsonValue::asJsonObject).get()));
        }
        if (set.isPresent()) {
            return set.get();
        }
        return this.normalize(result);
    }

    private JsonValue normalize(JsonMapBuilder result) throws JsonLdError {
        if (result.containsKey("@annotation") && (StringUtils.isBlank(this.activeProperty) || "@graph".equals(this.activeProperty) || "@included".equals(this.activeProperty) || result.get("@annotation").filter(NodeObject::isNotAnnotationObject).isPresent())) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_ANNOTATION);
        }
        if (result.size() == 1 && result.containsKey("@language")) {
            return JsonValue.NULL;
        }
        if (this.activeProperty == null || "@graph".equals(this.activeProperty)) {
            if (!this.frameExpansion && result.isEmpty() || result.containsKey("@value") || result.containsKey("@list")) {
                return JsonValue.NULL;
            }
            if (!this.frameExpansion && result.size() == 1 && result.containsKey("@id")) {
                return JsonValue.NULL;
            }
        }
        return result.build();
    }
}

