/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.datatypes.xsd;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import org.apache.jena.datatypes.BaseDatatype;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDbase64Binary;
import org.apache.jena.datatypes.xsd.XSDhexBinary;
import org.apache.jena.datatypes.xsd.impl.XSDBaseNumericType;
import org.apache.jena.datatypes.xsd.impl.XSDBaseStringType;
import org.apache.jena.datatypes.xsd.impl.XSDByteType;
import org.apache.jena.datatypes.xsd.impl.XSDDateTimeStampType;
import org.apache.jena.datatypes.xsd.impl.XSDDateTimeType;
import org.apache.jena.datatypes.xsd.impl.XSDDateType;
import org.apache.jena.datatypes.xsd.impl.XSDDayTimeDurationType;
import org.apache.jena.datatypes.xsd.impl.XSDDayType;
import org.apache.jena.datatypes.xsd.impl.XSDDouble;
import org.apache.jena.datatypes.xsd.impl.XSDDurationType;
import org.apache.jena.datatypes.xsd.impl.XSDFloat;
import org.apache.jena.datatypes.xsd.impl.XSDMonthDayType;
import org.apache.jena.datatypes.xsd.impl.XSDMonthType;
import org.apache.jena.datatypes.xsd.impl.XSDPlainType;
import org.apache.jena.datatypes.xsd.impl.XSDTimeType;
import org.apache.jena.datatypes.xsd.impl.XSDYearMonthDurationType;
import org.apache.jena.datatypes.xsd.impl.XSDYearMonthType;
import org.apache.jena.datatypes.xsd.impl.XSDYearType;
import org.apache.jena.ext.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.jena.ext.xerces.impl.dv.SchemaDVFactory;
import org.apache.jena.ext.xerces.impl.dv.ValidatedInfo;
import org.apache.jena.ext.xerces.impl.dv.ValidationContext;
import org.apache.jena.ext.xerces.impl.dv.XSSimpleType;
import org.apache.jena.ext.xerces.impl.dv.util.Base64;
import org.apache.jena.ext.xerces.impl.dv.util.HexBin;
import org.apache.jena.ext.xerces.impl.dv.xs.DecimalDV;
import org.apache.jena.ext.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.jena.ext.xerces.impl.validation.ValidationState;
import org.apache.jena.ext.xerces.util.SymbolHash;
import org.apache.jena.ext.xerces.xs.XSTypeDefinition;
import org.apache.jena.graph.impl.LiteralLabel;

public class XSDDatatype
extends BaseDatatype {
    public static final String XSD = "http://www.w3.org/2001/XMLSchema";
    public static final XSDDatatype XSDfloat = new XSDFloat("float", Float.class);
    public static final XSDDatatype XSDdouble = new XSDDouble("double", Double.class);
    public static final XSDDatatype XSDint = new XSDBaseNumericType("int", Integer.class);
    public static final XSDDatatype XSDlong = new XSDBaseNumericType("long", Long.class);
    public static final XSDDatatype XSDshort = new XSDBaseNumericType("short", Short.class);
    public static final XSDDatatype XSDbyte = new XSDByteType("byte", Byte.class);
    public static final XSDDatatype XSDunsignedByte = new XSDBaseNumericType("unsignedByte");
    public static final XSDDatatype XSDunsignedShort = new XSDBaseNumericType("unsignedShort");
    public static final XSDDatatype XSDunsignedInt = new XSDBaseNumericType("unsignedInt");
    public static final XSDDatatype XSDunsignedLong = new XSDBaseNumericType("unsignedLong");
    public static final XSDDatatype XSDdecimal = new XSDBaseNumericType("decimal", BigDecimal.class);
    public static final XSDDatatype XSDinteger = new XSDBaseNumericType("integer", BigInteger.class);
    public static final XSDDatatype XSDnonPositiveInteger = new XSDBaseNumericType("nonPositiveInteger");
    public static final XSDDatatype XSDnonNegativeInteger = new XSDBaseNumericType("nonNegativeInteger");
    public static final XSDDatatype XSDpositiveInteger = new XSDBaseNumericType("positiveInteger");
    public static final XSDDatatype XSDnegativeInteger = new XSDBaseNumericType("negativeInteger");
    public static final XSDDatatype XSDboolean = new XSDDatatype("boolean", Boolean.class);
    public static final XSDDatatype XSDstring = new XSDBaseStringType("string", String.class);
    public static final XSDDatatype XSDnormalizedString = new XSDBaseStringType("normalizedString", String.class);
    public static final XSDDatatype XSDanyURI = new XSDPlainType("anyURI", URI.class);
    public static final XSDDatatype XSDtoken = new XSDBaseStringType("token");
    public static final XSDDatatype XSDName = new XSDBaseStringType("Name");
    public static final XSDDatatype XSDQName = new XSDPlainType("QName");
    public static final XSDDatatype XSDlanguage = new XSDBaseStringType("language");
    public static final XSDDatatype XSDNMTOKEN = new XSDBaseStringType("NMTOKEN");
    public static final XSDDatatype XSDENTITY = new XSDBaseStringType("ENTITY");
    public static final XSDDatatype XSDID = new XSDBaseStringType("ID");
    public static final XSDDatatype XSDNCName = new XSDBaseStringType("NCName");
    public static final XSDDatatype XSDIDREF = new XSDPlainType("IDREF");
    public static final XSDDatatype XSDNOTATION = new XSDPlainType("NOTATION");
    public static final XSDDatatype XSDhexBinary = new XSDhexBinary("hexBinary");
    public static final XSDDatatype XSDbase64Binary = new XSDbase64Binary("base64Binary");
    public static final XSDDatatype XSDdate = new XSDDateType("date");
    public static final XSDDatatype XSDtime = new XSDTimeType("time");
    public static final XSDDatatype XSDdateTime = new XSDDateTimeType("dateTime");
    public static final XSDDatatype XSDdateTimeStamp = new XSDDateTimeStampType("dateTimeStamp");
    public static final XSDDatatype XSDduration = new XSDDurationType();
    public static final XSDDatatype XSDdayTimeDuration = new XSDDayTimeDurationType();
    public static final XSDDatatype XSDyearMonthDuration = new XSDYearMonthDurationType();
    public static final XSDDatatype XSDgDay = new XSDDayType("gDay");
    public static final XSDDatatype XSDgMonth = new XSDMonthType("gMonth");
    public static final XSDDatatype XSDgYear = new XSDYearType("gYear");
    public static final XSDDatatype XSDgYearMonth = new XSDYearMonthType("gYearMonth");
    public static final XSDDatatype XSDgMonthDay = new XSDMonthDayType("gMonthDay");
    XSSimpleType typeDeclaration;
    protected Class<?> javaClass = null;
    static final DecimalDV decimalDV = new DecimalDV();

    public XSDDatatype(String typeName) {
        super("");
        this.typeDeclaration = SchemaDVFactory.getInstance().getBuiltInType(typeName);
        this.uri = this.typeDeclaration.getNamespace() + "#" + this.typeDeclaration.getName();
    }

    public XSDDatatype(String typeName, Class<?> javaClass) {
        this(typeName);
        this.javaClass = javaClass;
    }

    protected XSDDatatype(XSSimpleType xstype, String namespace) {
        super("");
        this.typeDeclaration = xstype;
        this.uri = namespace + "#" + this.typeDeclaration.getName();
    }

    @Override
    public Object parse(String lexicalForm) throws DatatypeFormatException {
        try {
            ValidationState context = new ValidationState();
            ValidatedInfo resultInfo = new ValidatedInfo();
            this.typeDeclaration.validate(lexicalForm, (ValidationContext)context, resultInfo);
            return this.convertValidatedDataValue(resultInfo);
        }
        catch (InvalidDatatypeValueException e) {
            throw new DatatypeFormatException(lexicalForm, (RDFDatatype)this, "during parse -" + e);
        }
    }

    @Override
    public String unparse(Object value) {
        return value.toString();
    }

    @Override
    public boolean isEqual(LiteralLabel value1, LiteralLabel value2) {
        return this.typeDeclaration.isEqual(value1.getValue(), value2.getValue());
    }

    @Override
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public Object extendedTypeDefinition() {
        return this.typeDeclaration;
    }

    Object convertValidatedDataValue(ValidatedInfo validatedInfo) throws DatatypeFormatException {
        switch (validatedInfo.actualValueType) {
            case 17: {
                byte[] decoded = Base64.decode(validatedInfo.normalizedValue);
                return decoded;
            }
            case 3: {
                return validatedInfo.actualValue;
            }
            case 16: {
                byte[] decoded = HexBin.decode(validatedInfo.normalizedValue);
                return decoded;
            }
            case 34: 
            case 40: {
                return Integer.valueOf(XSDDatatype.trimPlus(validatedInfo.normalizedValue));
            }
            case 33: 
            case 39: {
                return this.suitableInteger(XSDDatatype.trimPlus(validatedInfo.normalizedValue));
            }
            case 35: 
            case 36: 
            case 41: {
                return Integer.valueOf(XSDDatatype.trimPlus(validatedInfo.normalizedValue));
            }
            case 4: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 42: {
                Object xsdValue = validatedInfo.actualValue;
                if (decimalDV.getTotalDigits(xsdValue) == 0) {
                    return 0;
                }
                if (decimalDV.getFractionDigits(xsdValue) >= 1) {
                    BigDecimal value = new BigDecimal(XSDDatatype.trimPlus(validatedInfo.normalizedValue));
                    return XSDdecimal.cannonicalise(value);
                }
                String lexical = XSDDatatype.trimPlus(validatedInfo.normalizedValue);
                int dotx = lexical.indexOf(46);
                if (dotx != -1) {
                    lexical = lexical.substring(0, dotx);
                }
                if (decimalDV.getTotalDigits(xsdValue) > 18) {
                    return new BigInteger(lexical);
                }
                return this.suitableInteger(lexical);
            }
        }
        return this.parseValidated(validatedInfo.normalizedValue);
    }

    protected Number suitableInteger(String lexical) {
        long number = Long.parseLong(lexical);
        return XSDDatatype.suitableInteger(number);
    }

    protected static Number suitableInteger(long number) {
        if (number > Integer.MAX_VALUE || number < Integer.MIN_VALUE) {
            return number;
        }
        return (int)number;
    }

    public Object parseValidated(String lexical) {
        return lexical;
    }

    @Override
    public boolean isValidLiteral(LiteralLabel lit) {
        return this.isBaseTypeCompatible(lit) && this.isValid(lit.getLexicalForm());
    }

    public boolean isBaseTypeCompatible(LiteralLabel lit) {
        XSTypeDefinition base = this.getFoundingType();
        RDFDatatype litDT = lit.getDatatype();
        if (litDT instanceof XSDDatatype) {
            XSTypeDefinition litBase = ((XSDDatatype)litDT).getFoundingType();
            return base.equals(litBase);
        }
        if (litDT == null && lit.language().equals("")) {
            return base.equals(XSDDatatype.XSDstring.typeDeclaration);
        }
        return false;
    }

    private XSTypeDefinition getFoundingType() {
        XSTypeDefinition founding = this.typeDeclaration;
        XSTypeDefinition parent = founding.getBaseType();
        if (parent == null) {
            return founding;
        }
        while (parent.getBaseType() != null) {
            founding = parent;
            parent = parent.getBaseType();
        }
        return founding;
    }

    public static String trimPlus(String str) {
        int i = str.indexOf(43);
        if (i == -1) {
            return str;
        }
        return str.substring(i + 1);
    }

    public static void loadXSDSimpleTypes(TypeMapper tm) {
        tm.registerDatatype(new XSDDatatype("anySimpleType"));
        tm.registerDatatype(XSDdecimal);
        tm.registerDatatype(XSDinteger);
        tm.registerDatatype(XSDnonPositiveInteger);
        tm.registerDatatype(XSDnonNegativeInteger);
        tm.registerDatatype(XSDpositiveInteger);
        tm.registerDatatype(XSDnegativeInteger);
        tm.registerDatatype(XSDbyte);
        tm.registerDatatype(XSDunsignedByte);
        tm.registerDatatype(XSDdouble);
        tm.registerDatatype(XSDfloat);
        tm.registerDatatype(XSDlong);
        tm.registerDatatype(XSDunsignedInt);
        tm.registerDatatype(XSDunsignedShort);
        tm.registerDatatype(XSDunsignedLong);
        tm.registerDatatype(XSDint);
        tm.registerDatatype(XSDshort);
        tm.registerDatatype(XSDboolean);
        tm.registerDatatype(XSDbase64Binary);
        tm.registerDatatype(XSDhexBinary);
        tm.registerDatatype(XSDdate);
        tm.registerDatatype(XSDtime);
        tm.registerDatatype(XSDdateTime);
        tm.registerDatatype(XSDdateTimeStamp);
        tm.registerDatatype(XSDduration);
        tm.registerDatatype(XSDyearMonthDuration);
        tm.registerDatatype(XSDdayTimeDuration);
        tm.registerDatatype(XSDgYearMonth);
        tm.registerDatatype(XSDgMonthDay);
        tm.registerDatatype(XSDgMonth);
        tm.registerDatatype(XSDgDay);
        tm.registerDatatype(XSDgYear);
        tm.registerDatatype(XSDnormalizedString);
        tm.registerDatatype(XSDstring);
        tm.registerDatatype(XSDanyURI);
        tm.registerDatatype(XSDtoken);
        tm.registerDatatype(XSDName);
        tm.registerDatatype(XSDlanguage);
        tm.registerDatatype(XSDQName);
        tm.registerDatatype(XSDNMTOKEN);
        tm.registerDatatype(XSDID);
        tm.registerDatatype(XSDENTITY);
        tm.registerDatatype(XSDNCName);
        tm.registerDatatype(XSDNOTATION);
        tm.registerDatatype(XSDIDREF);
    }

    public static void main(String[] args) {
        SymbolHash types = SchemaDVFactory.getInstance().getBuiltInTypes();
        int len = types.getLength();
        Object[] values = new Object[len];
        types.getValues(values, 0);
        for (Object value : values) {
            if (value instanceof XSSimpleTypeDecl) {
                XSSimpleTypeDecl decl = (XSSimpleTypeDecl)value;
                System.out.println("tm.registerDatatype(new XSDDatatype(\"" + decl.getName() + "\"));");
                continue;
            }
            System.out.println(" - " + value);
        }
    }

    public static class XSDGenericType
    extends XSDDatatype {
        XSDGenericType(XSSimpleType xstype, String namespace) {
            super(xstype, namespace);
        }
    }
}

