/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.http.HttpClient;
import java.util.function.Consumer;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.http.auth.AuthDomain;
import org.apache.jena.http.auth.AuthEnv;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.web.AuthSetup;

public class LibSec {
    public static Authenticator authenticator(final String user, final String password) {
        return new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, password.toCharArray());
            }
        };
    }

    public static HttpClient httpClient(AuthSetup authSetup) {
        Authenticator a = LibSec.authenticator(authSetup.user, authSetup.password);
        return HttpEnv.httpClientBuilder().authenticator(a).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withAuth(String urlStr, AuthSetup auth, Consumer<RDFConnection> action) {
        URI urix = URI.create(urlStr);
        AuthDomain domain = new AuthDomain(urix, null);
        try {
            AuthEnv.get().registerUsernamePassword(urix, auth.user, auth.password);
            try (RDFConnection conn = RDFConnectionRemote.newBuilder().destination(urlStr).build();){
                action.accept(conn);
            }
        }
        finally {
            AuthEnv.get().unregisterUsernamePassword(urix);
        }
    }
}

